<?php

namespace EnumType;

/**
 * This class stands for pttTypeEnum EnumType
 * @subpackage Enumerations
 */
class PttTypeEnum
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'PTT_DEVICE'
     * @return string 'PTT_DEVICE'
     */
    const VALUE_PTT_DEVICE = 'PTT_DEVICE';
    /**
     * Constant for value 'PTT_TALKGROUP'
     * @return string 'PTT_TALKGROUP'
     */
    const VALUE_PTT_TALKGROUP = 'PTT_TALKGROUP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_PTT_DEVICE
     * @uses self::VALUE_PTT_TALKGROUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_PTT_DEVICE,
            self::VALUE_PTT_TALKGROUP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
