<?php

namespace EnumType;

/**
 * This class stands for prepaidLanguageTypeEnum EnumType
 * @subpackage Enumerations
 */
class PrepaidLanguageTypeEnum
{
    /**
     * Constant for value 'ENGLISH'
     * @return string 'ENGLISH'
     */
    const VALUE_ENGLISH = 'ENGLISH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENGLISH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENGLISH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
