<?php

namespace EnumType;

/**
 * This class stands for poolGroupTypeEnum EnumType
 * @subpackage Enumerations
 */
class PoolGroupTypeEnum
{
    /**
     * Constant for value 'STATIC'
     * @return string 'STATIC'
     */
    const VALUE_STATIC = 'STATIC';
    /**
     * Constant for value 'DYNAMIC'
     * @return string 'DYNAMIC'
     */
    const VALUE_DYNAMIC = 'DYNAMIC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STATIC
     * @uses self::VALUE_DYNAMIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STATIC,
            self::VALUE_DYNAMIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
