<?php

namespace EnumType;

/**
 * This class stands for networkEnum EnumType
 * @subpackage Enumerations
 */
class NetworkEnum
{
    /**
     * Constant for value 'PROD'
     * @return string 'PROD'
     */
    const VALUE_PROD = 'PROD';
    /**
     * Constant for value 'TEST'
     * @return string 'TEST'
     */
    const VALUE_TEST = 'TEST';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PROD
     * @uses self::VALUE_TEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PROD,
            self::VALUE_TEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
