<?php

namespace EnumType;

/**
 * This class stands for modelServiceCategoryEnum EnumType
 * @subpackage Enumerations
 */
class ModelServiceCategoryEnum
{
    /**
     * Constant for value 'STANDARD'
     * @return string 'STANDARD'
     */
    const VALUE_STANDARD = 'STANDARD';
    /**
     * Constant for value 'HIGH'
     * @return string 'HIGH'
     */
    const VALUE_HIGH = 'HIGH';
    /**
     * Constant for value 'ULTRA'
     * @return string 'ULTRA'
     */
    const VALUE_ULTRA = 'ULTRA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_HIGH
     * @uses self::VALUE_ULTRA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_HIGH,
            self::VALUE_ULTRA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
