<?php

namespace EnumType;

/**
 * This class stands for lineTypeEnum EnumType
 * @subpackage Enumerations
 */
class LineTypeEnum
{
    /**
     * Constant for value 'CREW'
     * @return string 'CREW'
     */
    const VALUE_CREW = 'CREW';
    /**
     * Constant for value 'STANDARD'
     * @return string 'STANDARD'
     */
    const VALUE_STANDARD = 'STANDARD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREW
     * @uses self::VALUE_STANDARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREW,
            self::VALUE_STANDARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
