<?php

namespace EnumType;

/**
 * This class stands for extractionFormatEnum EnumType
 * @subpackage Enumerations
 */
class ExtractionFormatEnum
{
    /**
     * Constant for value 'NA'
     * @return string 'NA'
     */
    const VALUE_NA = 'NA';
    /**
     * Constant for value 'TAP2'
     * @return string 'TAP2'
     */
    const VALUE_TAP_2 = 'TAP2';
    /**
     * Constant for value 'NATAP2'
     * @return string 'NATAP2'
     */
    const VALUE_NATAP_2 = 'NATAP2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NA
     * @uses self::VALUE_TAP_2
     * @uses self::VALUE_NATAP_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NA,
            self::VALUE_TAP_2,
            self::VALUE_NATAP_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
