<?php

namespace EnumType;

/**
 * This class stands for emailNotificationTypeEnum EnumType
 * @subpackage Enumerations
 */
class EmailNotificationTypeEnum
{
    /**
     * Constant for value 'ACT_CREATE'
     * @return string 'ACT_CREATE'
     */
    const VALUE_ACT_CREATE = 'ACT_CREATE';
    /**
     * Constant for value 'PLAN_TRANS'
     * @return string 'PLAN_TRANS'
     */
    const VALUE_PLAN_TRANS = 'PLAN_TRANS';
    /**
     * Constant for value 'DE_ACTIVATE'
     * @return string 'DE_ACTIVATE'
     */
    const VALUE_DE_ACTIVATE = 'DE_ACTIVATE';
    /**
     * Constant for value 'UN_SUSPEND'
     * @return string 'UN_SUSPEND'
     */
    const VALUE_UN_SUSPEND = 'UN_SUSPEND';
    /**
     * Constant for value 'SUSPEND'
     * @return string 'SUSPEND'
     */
    const VALUE_SUSPEND = 'SUSPEND';
    /**
     * Constant for value 'DEV_SWAP'
     * @return string 'DEV_SWAP'
     */
    const VALUE_DEV_SWAP = 'DEV_SWAP';
    /**
     * Constant for value 'SUPP_ON'
     * @return string 'SUPP_ON'
     */
    const VALUE_SUPP_ON = 'SUPP_ON';
    /**
     * Constant for value 'SUPP_OFF'
     * @return string 'SUPP_OFF'
     */
    const VALUE_SUPP_OFF = 'SUPP_OFF';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACT_CREATE
     * @uses self::VALUE_PLAN_TRANS
     * @uses self::VALUE_DE_ACTIVATE
     * @uses self::VALUE_UN_SUSPEND
     * @uses self::VALUE_SUSPEND
     * @uses self::VALUE_DEV_SWAP
     * @uses self::VALUE_SUPP_ON
     * @uses self::VALUE_SUPP_OFF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACT_CREATE,
            self::VALUE_PLAN_TRANS,
            self::VALUE_DE_ACTIVATE,
            self::VALUE_UN_SUSPEND,
            self::VALUE_SUSPEND,
            self::VALUE_DEV_SWAP,
            self::VALUE_SUPP_ON,
            self::VALUE_SUPP_OFF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
