<?php

namespace EnumType;

/**
 * This class stands for deviceTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeviceTypeEnum
{
    /**
     * Constant for value 'SIM'
     * @return string 'SIM'
     */
    const VALUE_SIM = 'SIM';
    /**
     * Constant for value 'IP'
     * @return string 'IP'
     */
    const VALUE_IP = 'IP';
    /**
     * Constant for value 'NUM'
     * @return string 'NUM'
     */
    const VALUE_NUM = 'NUM';
    /**
     * Constant for value 'VPN'
     * @return string 'VPN'
     */
    const VALUE_VPN = 'VPN';
    /**
     * Constant for value 'VOUCHER'
     * @return string 'VOUCHER'
     */
    const VALUE_VOUCHER = 'VOUCHER';
    /**
     * Constant for value 'IMEI'
     * @return string 'IMEI'
     */
    const VALUE_IMEI = 'IMEI';
    /**
     * Constant for value 'CAPCODE'
     * @return string 'CAPCODE'
     */
    const VALUE_CAPCODE = 'CAPCODE';
    /**
     * Constant for value 'ISDNA'
     * @return string 'ISDNA'
     */
    const VALUE_ISDNA = 'ISDNA';
    /**
     * Constant for value 'PLUSONE'
     * @return string 'PLUSONE'
     */
    const VALUE_PLUSONE = 'PLUSONE';
    /**
     * Constant for value 'LOCAL_NUMBER'
     * @return string 'LOCAL_NUMBER'
     */
    const VALUE_LOCAL_NUMBER = 'LOCAL_NUMBER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SIM
     * @uses self::VALUE_IP
     * @uses self::VALUE_NUM
     * @uses self::VALUE_VPN
     * @uses self::VALUE_VOUCHER
     * @uses self::VALUE_IMEI
     * @uses self::VALUE_CAPCODE
     * @uses self::VALUE_ISDNA
     * @uses self::VALUE_PLUSONE
     * @uses self::VALUE_LOCAL_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SIM,
            self::VALUE_IP,
            self::VALUE_NUM,
            self::VALUE_VPN,
            self::VALUE_VOUCHER,
            self::VALUE_IMEI,
            self::VALUE_CAPCODE,
            self::VALUE_ISDNA,
            self::VALUE_PLUSONE,
            self::VALUE_LOCAL_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
