<?php

namespace EnumType;

/**
 * This class stands for deviceStringTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeviceStringTypeEnum
{
    /**
     * Constant for value 'CAPCODE'
     * @return string 'CAPCODE'
     */
    const VALUE_CAPCODE = 'CAPCODE';
    /**
     * Constant for value 'IMEI'
     * @return string 'IMEI'
     */
    const VALUE_IMEI = 'IMEI';
    /**
     * Constant for value 'ISDNA'
     * @return string 'ISDNA'
     */
    const VALUE_ISDNA = 'ISDNA';
    /**
     * Constant for value 'MSISDN'
     * @return string 'MSISDN'
     */
    const VALUE_MSISDN = 'MSISDN';
    /**
     * Constant for value 'MSISDNB'
     * @return string 'MSISDNB'
     */
    const VALUE_MSISDNB = 'MSISDNB';
    /**
     * Constant for value 'MSISDNC'
     * @return string 'MSISDNC'
     */
    const VALUE_MSISDNC = 'MSISDNC';
    /**
     * Constant for value 'PLUS1'
     * @return string 'PLUS1'
     */
    const VALUE_PLUS_1 = 'PLUS1';
    /**
     * Constant for value 'PLUS7'
     * @return string 'PLUS7'
     */
    const VALUE_PLUS_7 = 'PLUS7';
    /**
     * Constant for value 'SIM'
     * @return string 'SIM'
     */
    const VALUE_SIM = 'SIM';
    /**
     * Constant for value 'IPADDR'
     * @return string 'IPADDR'
     */
    const VALUE_IPADDR = 'IPADDR';
    /**
     * Constant for value 'ATS_ICAO'
     * @return string 'ATS_ICAO'
     */
    const VALUE_ATS_ICAO = 'ATS_ICAO';
    /**
     * Constant for value 'ATS_TAIL_NUMBER'
     * @return string 'ATS_TAIL_NUMBER'
     */
    const VALUE_ATS_TAIL_NUMBER = 'ATS_TAIL_NUMBER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAPCODE
     * @uses self::VALUE_IMEI
     * @uses self::VALUE_ISDNA
     * @uses self::VALUE_MSISDN
     * @uses self::VALUE_MSISDNB
     * @uses self::VALUE_MSISDNC
     * @uses self::VALUE_PLUS_1
     * @uses self::VALUE_PLUS_7
     * @uses self::VALUE_SIM
     * @uses self::VALUE_IPADDR
     * @uses self::VALUE_ATS_ICAO
     * @uses self::VALUE_ATS_TAIL_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAPCODE,
            self::VALUE_IMEI,
            self::VALUE_ISDNA,
            self::VALUE_MSISDN,
            self::VALUE_MSISDNB,
            self::VALUE_MSISDNC,
            self::VALUE_PLUS_1,
            self::VALUE_PLUS_7,
            self::VALUE_SIM,
            self::VALUE_IPADDR,
            self::VALUE_ATS_ICAO,
            self::VALUE_ATS_TAIL_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
