<?php

namespace EnumType;

/**
 * This class stands for deliveryStatusTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeliveryStatusTypeEnum
{
    /**
     * Constant for value 'DELIVERED'
     * @return string 'DELIVERED'
     */
    const VALUE_DELIVERED = 'DELIVERED';
    /**
     * Constant for value 'DELIVERYCONFIRMED'
     * @return string 'DELIVERYCONFIRMED'
     */
    const VALUE_DELIVERYCONFIRMED = 'DELIVERYCONFIRMED';
    /**
     * Constant for value 'NOTDELIVERED'
     * @return string 'NOTDELIVERED'
     */
    const VALUE_NOTDELIVERED = 'NOTDELIVERED';
    /**
     * Constant for value 'SSDTOSSD_PAYLOADINVALID'
     * @return string 'SSDTOSSD_PAYLOADINVALID'
     */
    const VALUE_SSDTOSSD_PAYLOADINVALID = 'SSDTOSSD_PAYLOADINVALID';
    /**
     * Constant for value 'SSDTOSSD_QUEUEFULL'
     * @return string 'SSDTOSSD_QUEUEFULL'
     */
    const VALUE_SSDTOSSD_QUEUEFULL = 'SSDTOSSD_QUEUEFULL';
    /**
     * Constant for value 'SSDTOSSD_EMBC'
     * @return string 'SSDTOSSD_EMBC'
     */
    const VALUE_SSDTOSSD_EMBC = 'SSDTOSSD_EMBC';
    /**
     * Constant for value 'SSDTOSSD_UNKNOWNSSD'
     * @return string 'SSDTOSSD_UNKNOWNSSD'
     */
    const VALUE_SSDTOSSD_UNKNOWNSSD = 'SSDTOSSD_UNKNOWNSSD';
    /**
     * Constant for value 'DIRECTIP_TIMEOUT'
     * @return string 'DIRECTIP_TIMEOUT'
     */
    const VALUE_DIRECTIP_TIMEOUT = 'DIRECTIP_TIMEOUT';
    /**
     * Constant for value 'DIRECTIP_QUEUEOVERFLOW'
     * @return string 'DIRECTIP_QUEUEOVERFLOW'
     */
    const VALUE_DIRECTIP_QUEUEOVERFLOW = 'DIRECTIP_QUEUEOVERFLOW';
    /**
     * Constant for value 'DIRECTIP_DELETED'
     * @return string 'DIRECTIP_DELETED'
     */
    const VALUE_DIRECTIP_DELETED = 'DIRECTIP_DELETED';
    /**
     * Constant for value 'DIRECTIP_FLUSHED'
     * @return string 'DIRECTIP_FLUSHED'
     */
    const VALUE_DIRECTIP_FLUSHED = 'DIRECTIP_FLUSHED';
    /**
     * Constant for value 'INVALIDEMAIL'
     * @return string 'INVALIDEMAIL'
     */
    const VALUE_INVALIDEMAIL = 'INVALIDEMAIL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DELIVERED
     * @uses self::VALUE_DELIVERYCONFIRMED
     * @uses self::VALUE_NOTDELIVERED
     * @uses self::VALUE_SSDTOSSD_PAYLOADINVALID
     * @uses self::VALUE_SSDTOSSD_QUEUEFULL
     * @uses self::VALUE_SSDTOSSD_EMBC
     * @uses self::VALUE_SSDTOSSD_UNKNOWNSSD
     * @uses self::VALUE_DIRECTIP_TIMEOUT
     * @uses self::VALUE_DIRECTIP_QUEUEOVERFLOW
     * @uses self::VALUE_DIRECTIP_DELETED
     * @uses self::VALUE_DIRECTIP_FLUSHED
     * @uses self::VALUE_INVALIDEMAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DELIVERED,
            self::VALUE_DELIVERYCONFIRMED,
            self::VALUE_NOTDELIVERED,
            self::VALUE_SSDTOSSD_PAYLOADINVALID,
            self::VALUE_SSDTOSSD_QUEUEFULL,
            self::VALUE_SSDTOSSD_EMBC,
            self::VALUE_SSDTOSSD_UNKNOWNSSD,
            self::VALUE_DIRECTIP_TIMEOUT,
            self::VALUE_DIRECTIP_QUEUEOVERFLOW,
            self::VALUE_DIRECTIP_DELETED,
            self::VALUE_DIRECTIP_FLUSHED,
            self::VALUE_INVALIDEMAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
