<?php

namespace EnumType;

/**
 * This class stands for deliveryMethodTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeliveryMethodTypeEnum
{
    /**
     * Constant for value 'EMAIL'
     * @return string 'EMAIL'
     */
    const VALUE_EMAIL = 'EMAIL';
    /**
     * Constant for value 'DIRECT_IP'
     * @return string 'DIRECT_IP'
     */
    const VALUE_DIRECT_IP = 'DIRECT_IP';
    /**
     * Constant for value 'IRIDIUM_DEVICE'
     * @return string 'IRIDIUM_DEVICE'
     */
    const VALUE_IRIDIUM_DEVICE = 'IRIDIUM_DEVICE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_DIRECT_IP
     * @uses self::VALUE_IRIDIUM_DEVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMAIL,
            self::VALUE_DIRECT_IP,
            self::VALUE_IRIDIUM_DEVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
