<?php

namespace EnumType;

/**
 * This class stands for activationTypeEnum EnumType
 * @subpackage Enumerations
 */
class ActivationTypeEnum
{
    /**
     * Constant for value 'FULL'
     * @return string 'FULL'
     */
    const VALUE_FULL = 'FULL';
    /**
     * Constant for value 'LINEITEM'
     * @return string 'LINEITEM'
     */
    const VALUE_LINEITEM = 'LINEITEM';
    /**
     * Constant for value 'RANGE'
     * @return string 'RANGE'
     */
    const VALUE_RANGE = 'RANGE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FULL
     * @uses self::VALUE_LINEITEM
     * @uses self::VALUE_RANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FULL,
            self::VALUE_LINEITEM,
            self::VALUE_RANGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
