<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingMultiParcelV2 StructType
 * Meta information extracted from the WSDL
 * - type: tns:shippingMultiParcelV2
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostShippingMultiParcelV2 extends AbstractStructBase
{
    /**
     * The esdValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostEsdValue3
     */
    public $esdValue;
    /**
     * The headerValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostHeaderValue
     */
    public $headerValue;
    /**
     * The shipperValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostShipperValueV2[]
     */
    public $shipperValue;
    /**
     * The customerValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostCustomerValue
     */
    public $customerValue;
    /**
     * The recipientValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRecipientValue[]
     */
    public $recipientValue;
    /**
     * The refValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRefValue[]
     */
    public $refValue;
    /**
     * The skybillValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4[]
     */
    public $skybillValue;
    /**
     * The skybillParamsValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostSkybillParamsValueV2
     */
    public $skybillParamsValue;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The modeRetour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $modeRetour;
    /**
     * The numberOfParcel
     * @var int
     */
    public $numberOfParcel;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * The multiParcel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $multiParcel;
    /**
     * The scheduledValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostScheduledValue[]
     */
    public $scheduledValue;
    /**
     * The recipientLocalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRecipientLocalValue[]
     */
    public $recipientLocalValue;
    /**
     * The customsValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostCustomsValue[]
     */
    public $customsValue;
    /**
     * Constructor method for shippingMultiParcelV2
     * @uses WsChronopostShippingMultiParcelV2::setEsdValue()
     * @uses WsChronopostShippingMultiParcelV2::setHeaderValue()
     * @uses WsChronopostShippingMultiParcelV2::setShipperValue()
     * @uses WsChronopostShippingMultiParcelV2::setCustomerValue()
     * @uses WsChronopostShippingMultiParcelV2::setRecipientValue()
     * @uses WsChronopostShippingMultiParcelV2::setRefValue()
     * @uses WsChronopostShippingMultiParcelV2::setSkybillValue()
     * @uses WsChronopostShippingMultiParcelV2::setSkybillParamsValue()
     * @uses WsChronopostShippingMultiParcelV2::setPassword()
     * @uses WsChronopostShippingMultiParcelV2::setModeRetour()
     * @uses WsChronopostShippingMultiParcelV2::setNumberOfParcel()
     * @uses WsChronopostShippingMultiParcelV2::setVersion()
     * @uses WsChronopostShippingMultiParcelV2::setMultiParcel()
     * @uses WsChronopostShippingMultiParcelV2::setScheduledValue()
     * @uses WsChronopostShippingMultiParcelV2::setRecipientLocalValue()
     * @uses WsChronopostShippingMultiParcelV2::setCustomsValue()
     * @param \WsChronopost\StructType\WsChronopostEsdValue3 $esdValue
     * @param \WsChronopost\StructType\WsChronopostHeaderValue $headerValue
     * @param \WsChronopost\StructType\WsChronopostShipperValueV2[] $shipperValue
     * @param \WsChronopost\StructType\WsChronopostCustomerValue $customerValue
     * @param \WsChronopost\StructType\WsChronopostRecipientValue[] $recipientValue
     * @param \WsChronopost\StructType\WsChronopostRefValue[] $refValue
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4[] $skybillValue
     * @param \WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue
     * @param string $password
     * @param string $modeRetour
     * @param int $numberOfParcel
     * @param string $version
     * @param string $multiParcel
     * @param \WsChronopost\StructType\WsChronopostScheduledValue[] $scheduledValue
     * @param \WsChronopost\StructType\WsChronopostRecipientLocalValue[] $recipientLocalValue
     * @param \WsChronopost\StructType\WsChronopostCustomsValue[] $customsValue
     */
    public function __construct(\WsChronopost\StructType\WsChronopostEsdValue3 $esdValue = null, \WsChronopost\StructType\WsChronopostHeaderValue $headerValue = null, array $shipperValue = array(), \WsChronopost\StructType\WsChronopostCustomerValue $customerValue = null, array $recipientValue = array(), array $refValue = array(), array $skybillValue = array(), \WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue = null, $password = null, $modeRetour = null, $numberOfParcel = null, $version = null, $multiParcel = null, array $scheduledValue = array(), array $recipientLocalValue = array(), array $customsValue = array())
    {
        $this
            ->setEsdValue($esdValue)
            ->setHeaderValue($headerValue)
            ->setShipperValue($shipperValue)
            ->setCustomerValue($customerValue)
            ->setRecipientValue($recipientValue)
            ->setRefValue($refValue)
            ->setSkybillValue($skybillValue)
            ->setSkybillParamsValue($skybillParamsValue)
            ->setPassword($password)
            ->setModeRetour($modeRetour)
            ->setNumberOfParcel($numberOfParcel)
            ->setVersion($version)
            ->setMultiParcel($multiParcel)
            ->setScheduledValue($scheduledValue)
            ->setRecipientLocalValue($recipientLocalValue)
            ->setCustomsValue($customsValue);
    }
    /**
     * Get esdValue value
     * @return \WsChronopost\StructType\WsChronopostEsdValue3|null
     */
    public function getEsdValue()
    {
        return $this->esdValue;
    }
    /**
     * Set esdValue value
     * @param \WsChronopost\StructType\WsChronopostEsdValue3 $esdValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setEsdValue(\WsChronopost\StructType\WsChronopostEsdValue3 $esdValue = null)
    {
        $this->esdValue = $esdValue;
        return $this;
    }
    /**
     * Get headerValue value
     * @return \WsChronopost\StructType\WsChronopostHeaderValue|null
     */
    public function getHeaderValue()
    {
        return $this->headerValue;
    }
    /**
     * Set headerValue value
     * @param \WsChronopost\StructType\WsChronopostHeaderValue $headerValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setHeaderValue(\WsChronopost\StructType\WsChronopostHeaderValue $headerValue = null)
    {
        $this->headerValue = $headerValue;
        return $this;
    }
    /**
     * Get shipperValue value
     * @return \WsChronopost\StructType\WsChronopostShipperValueV2[]|null
     */
    public function getShipperValue()
    {
        return $this->shipperValue;
    }
    /**
     * This method is responsible for validating the values passed to the setShipperValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipperValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipperValueForArrayConstraintsFromSetShipperValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV2ShipperValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV2ShipperValueItem instanceof \WsChronopost\StructType\WsChronopostShipperValueV2) {
                $invalidValues[] = is_object($shippingMultiParcelV2ShipperValueItem) ? get_class($shippingMultiParcelV2ShipperValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV2ShipperValueItem), var_export($shippingMultiParcelV2ShipperValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipperValue property can only contain items of type \WsChronopost\StructType\WsChronopostShipperValueV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipperValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostShipperValueV2[] $shipperValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setShipperValue(array $shipperValue = array())
    {
        // validation for constraint: array
        if ('' !== ($shipperValueArrayErrorMessage = self::validateShipperValueForArrayConstraintsFromSetShipperValue($shipperValue))) {
            throw new \InvalidArgumentException($shipperValueArrayErrorMessage, __LINE__);
        }
        $this->shipperValue = $shipperValue;
        return $this;
    }
    /**
     * Add item to shipperValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostShipperValueV2 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function addToShipperValue(\WsChronopost\StructType\WsChronopostShipperValueV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostShipperValueV2) {
            throw new \InvalidArgumentException(sprintf('The shipperValue property can only contain items of type \WsChronopost\StructType\WsChronopostShipperValueV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipperValue[] = $item;
        return $this;
    }
    /**
     * Get customerValue value
     * @return \WsChronopost\StructType\WsChronopostCustomerValue|null
     */
    public function getCustomerValue()
    {
        return $this->customerValue;
    }
    /**
     * Set customerValue value
     * @param \WsChronopost\StructType\WsChronopostCustomerValue $customerValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setCustomerValue(\WsChronopost\StructType\WsChronopostCustomerValue $customerValue = null)
    {
        $this->customerValue = $customerValue;
        return $this;
    }
    /**
     * Get recipientValue value
     * @return \WsChronopost\StructType\WsChronopostRecipientValue[]|null
     */
    public function getRecipientValue()
    {
        return $this->recipientValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientValueForArrayConstraintsFromSetRecipientValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV2RecipientValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV2RecipientValueItem instanceof \WsChronopost\StructType\WsChronopostRecipientValue) {
                $invalidValues[] = is_object($shippingMultiParcelV2RecipientValueItem) ? get_class($shippingMultiParcelV2RecipientValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV2RecipientValueItem), var_export($shippingMultiParcelV2RecipientValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recipientValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recipientValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientValue[] $recipientValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setRecipientValue(array $recipientValue = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientValueArrayErrorMessage = self::validateRecipientValueForArrayConstraintsFromSetRecipientValue($recipientValue))) {
            throw new \InvalidArgumentException($recipientValueArrayErrorMessage, __LINE__);
        }
        $this->recipientValue = $recipientValue;
        return $this;
    }
    /**
     * Add item to recipientValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function addToRecipientValue(\WsChronopost\StructType\WsChronopostRecipientValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRecipientValue) {
            throw new \InvalidArgumentException(sprintf('The recipientValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recipientValue[] = $item;
        return $this;
    }
    /**
     * Get refValue value
     * @return \WsChronopost\StructType\WsChronopostRefValue[]|null
     */
    public function getRefValue()
    {
        return $this->refValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRefValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefValueForArrayConstraintsFromSetRefValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV2RefValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV2RefValueItem instanceof \WsChronopost\StructType\WsChronopostRefValue) {
                $invalidValues[] = is_object($shippingMultiParcelV2RefValueItem) ? get_class($shippingMultiParcelV2RefValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV2RefValueItem), var_export($shippingMultiParcelV2RefValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The refValue property can only contain items of type \WsChronopost\StructType\WsChronopostRefValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set refValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRefValue[] $refValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setRefValue(array $refValue = array())
    {
        // validation for constraint: array
        if ('' !== ($refValueArrayErrorMessage = self::validateRefValueForArrayConstraintsFromSetRefValue($refValue))) {
            throw new \InvalidArgumentException($refValueArrayErrorMessage, __LINE__);
        }
        $this->refValue = $refValue;
        return $this;
    }
    /**
     * Add item to refValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRefValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function addToRefValue(\WsChronopost\StructType\WsChronopostRefValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRefValue) {
            throw new \InvalidArgumentException(sprintf('The refValue property can only contain items of type \WsChronopost\StructType\WsChronopostRefValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->refValue[] = $item;
        return $this;
    }
    /**
     * Get skybillValue value
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4[]|null
     */
    public function getSkybillValue()
    {
        return $this->skybillValue;
    }
    /**
     * This method is responsible for validating the values passed to the setSkybillValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkybillValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkybillValueForArrayConstraintsFromSetSkybillValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV2SkybillValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV2SkybillValueItem instanceof \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4) {
                $invalidValues[] = is_object($shippingMultiParcelV2SkybillValueItem) ? get_class($shippingMultiParcelV2SkybillValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV2SkybillValueItem), var_export($shippingMultiParcelV2SkybillValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The skybillValue property can only contain items of type \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set skybillValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4[] $skybillValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setSkybillValue(array $skybillValue = array())
    {
        // validation for constraint: array
        if ('' !== ($skybillValueArrayErrorMessage = self::validateSkybillValueForArrayConstraintsFromSetSkybillValue($skybillValue))) {
            throw new \InvalidArgumentException($skybillValueArrayErrorMessage, __LINE__);
        }
        $this->skybillValue = $skybillValue;
        return $this;
    }
    /**
     * Add item to skybillValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function addToSkybillValue(\WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4) {
            throw new \InvalidArgumentException(sprintf('The skybillValue property can only contain items of type \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->skybillValue[] = $item;
        return $this;
    }
    /**
     * Get skybillParamsValue value
     * @return \WsChronopost\StructType\WsChronopostSkybillParamsValueV2|null
     */
    public function getSkybillParamsValue()
    {
        return $this->skybillParamsValue;
    }
    /**
     * Set skybillParamsValue value
     * @param \WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setSkybillParamsValue(\WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue = null)
    {
        $this->skybillParamsValue = $skybillParamsValue;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get modeRetour value
     * @return string|null
     */
    public function getModeRetour()
    {
        return $this->modeRetour;
    }
    /**
     * Set modeRetour value
     * @param string $modeRetour
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setModeRetour($modeRetour = null)
    {
        // validation for constraint: string
        if (!is_null($modeRetour) && !is_string($modeRetour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeRetour, true), gettype($modeRetour)), __LINE__);
        }
        $this->modeRetour = $modeRetour;
        return $this;
    }
    /**
     * Get numberOfParcel value
     * @return int|null
     */
    public function getNumberOfParcel()
    {
        return $this->numberOfParcel;
    }
    /**
     * Set numberOfParcel value
     * @param int $numberOfParcel
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setNumberOfParcel($numberOfParcel = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfParcel) && !(is_int($numberOfParcel) || ctype_digit($numberOfParcel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfParcel, true), gettype($numberOfParcel)), __LINE__);
        }
        $this->numberOfParcel = $numberOfParcel;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get multiParcel value
     * @return string|null
     */
    public function getMultiParcel()
    {
        return $this->multiParcel;
    }
    /**
     * Set multiParcel value
     * @param string $multiParcel
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setMultiParcel($multiParcel = null)
    {
        // validation for constraint: string
        if (!is_null($multiParcel) && !is_string($multiParcel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multiParcel, true), gettype($multiParcel)), __LINE__);
        }
        $this->multiParcel = $multiParcel;
        return $this;
    }
    /**
     * Get scheduledValue value
     * @return \WsChronopost\StructType\WsChronopostScheduledValue[]|null
     */
    public function getScheduledValue()
    {
        return $this->scheduledValue;
    }
    /**
     * This method is responsible for validating the values passed to the setScheduledValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setScheduledValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateScheduledValueForArrayConstraintsFromSetScheduledValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV2ScheduledValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV2ScheduledValueItem instanceof \WsChronopost\StructType\WsChronopostScheduledValue) {
                $invalidValues[] = is_object($shippingMultiParcelV2ScheduledValueItem) ? get_class($shippingMultiParcelV2ScheduledValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV2ScheduledValueItem), var_export($shippingMultiParcelV2ScheduledValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The scheduledValue property can only contain items of type \WsChronopost\StructType\WsChronopostScheduledValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set scheduledValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostScheduledValue[] $scheduledValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setScheduledValue(array $scheduledValue = array())
    {
        // validation for constraint: array
        if ('' !== ($scheduledValueArrayErrorMessage = self::validateScheduledValueForArrayConstraintsFromSetScheduledValue($scheduledValue))) {
            throw new \InvalidArgumentException($scheduledValueArrayErrorMessage, __LINE__);
        }
        $this->scheduledValue = $scheduledValue;
        return $this;
    }
    /**
     * Add item to scheduledValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostScheduledValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function addToScheduledValue(\WsChronopost\StructType\WsChronopostScheduledValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostScheduledValue) {
            throw new \InvalidArgumentException(sprintf('The scheduledValue property can only contain items of type \WsChronopost\StructType\WsChronopostScheduledValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->scheduledValue[] = $item;
        return $this;
    }
    /**
     * Get recipientLocalValue value
     * @return \WsChronopost\StructType\WsChronopostRecipientLocalValue[]|null
     */
    public function getRecipientLocalValue()
    {
        return $this->recipientLocalValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientLocalValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientLocalValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientLocalValueForArrayConstraintsFromSetRecipientLocalValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV2RecipientLocalValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV2RecipientLocalValueItem instanceof \WsChronopost\StructType\WsChronopostRecipientLocalValue) {
                $invalidValues[] = is_object($shippingMultiParcelV2RecipientLocalValueItem) ? get_class($shippingMultiParcelV2RecipientLocalValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV2RecipientLocalValueItem), var_export($shippingMultiParcelV2RecipientLocalValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recipientLocalValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientLocalValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recipientLocalValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientLocalValue[] $recipientLocalValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setRecipientLocalValue(array $recipientLocalValue = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientLocalValueArrayErrorMessage = self::validateRecipientLocalValueForArrayConstraintsFromSetRecipientLocalValue($recipientLocalValue))) {
            throw new \InvalidArgumentException($recipientLocalValueArrayErrorMessage, __LINE__);
        }
        $this->recipientLocalValue = $recipientLocalValue;
        return $this;
    }
    /**
     * Add item to recipientLocalValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientLocalValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function addToRecipientLocalValue(\WsChronopost\StructType\WsChronopostRecipientLocalValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRecipientLocalValue) {
            throw new \InvalidArgumentException(sprintf('The recipientLocalValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientLocalValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recipientLocalValue[] = $item;
        return $this;
    }
    /**
     * Get customsValue value
     * @return \WsChronopost\StructType\WsChronopostCustomsValue[]|null
     */
    public function getCustomsValue()
    {
        return $this->customsValue;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsValueForArrayConstraintsFromSetCustomsValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV2CustomsValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV2CustomsValueItem instanceof \WsChronopost\StructType\WsChronopostCustomsValue) {
                $invalidValues[] = is_object($shippingMultiParcelV2CustomsValueItem) ? get_class($shippingMultiParcelV2CustomsValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV2CustomsValueItem), var_export($shippingMultiParcelV2CustomsValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customsValue property can only contain items of type \WsChronopost\StructType\WsChronopostCustomsValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customsValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostCustomsValue[] $customsValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function setCustomsValue(array $customsValue = array())
    {
        // validation for constraint: array
        if ('' !== ($customsValueArrayErrorMessage = self::validateCustomsValueForArrayConstraintsFromSetCustomsValue($customsValue))) {
            throw new \InvalidArgumentException($customsValueArrayErrorMessage, __LINE__);
        }
        $this->customsValue = $customsValue;
        return $this;
    }
    /**
     * Add item to customsValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostCustomsValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public function addToCustomsValue(\WsChronopost\StructType\WsChronopostCustomsValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostCustomsValue) {
            throw new \InvalidArgumentException(sprintf('The customsValue property can only contain items of type \WsChronopost\StructType\WsChronopostCustomsValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customsValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
