<?php

namespace WsChronopost\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Faisabilite ServiceType
 * @package WsChronopost
 * @subpackage Services
 */
class WsChronopostFaisabilite extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named faisabiliteESD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostFaisabiliteESD $parameters
     * @return \WsChronopost\StructType\WsChronopostFaisabiliteESDResponse|bool
     */
    public function faisabiliteESD(\WsChronopost\StructType\WsChronopostFaisabiliteESD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->faisabiliteESD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WsChronopost\StructType\WsChronopostFaisabiliteESDResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
