<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for skybillWithDimensionsValueV3 StructType
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostSkybillWithDimensionsValueV3 extends WsChronopostSkybillWithDimensionsValueV2
{
    /**
     * The subAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subAccount;
    /**
     * The toTheOrderOf
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toTheOrderOf;
    /**
     * Constructor method for skybillWithDimensionsValueV3
     * @uses WsChronopostSkybillWithDimensionsValueV3::setSubAccount()
     * @uses WsChronopostSkybillWithDimensionsValueV3::setToTheOrderOf()
     * @param string $subAccount
     * @param string $toTheOrderOf
     */
    public function __construct($subAccount = null, $toTheOrderOf = null)
    {
        $this
            ->setSubAccount($subAccount)
            ->setToTheOrderOf($toTheOrderOf);
    }
    /**
     * Get subAccount value
     * @return string|null
     */
    public function getSubAccount()
    {
        return $this->subAccount;
    }
    /**
     * Set subAccount value
     * @param string $subAccount
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV3
     */
    public function setSubAccount($subAccount = null)
    {
        // validation for constraint: string
        if (!is_null($subAccount) && !is_string($subAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subAccount, true), gettype($subAccount)), __LINE__);
        }
        $this->subAccount = $subAccount;
        return $this;
    }
    /**
     * Get toTheOrderOf value
     * @return string|null
     */
    public function getToTheOrderOf()
    {
        return $this->toTheOrderOf;
    }
    /**
     * Set toTheOrderOf value
     * @param string $toTheOrderOf
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV3
     */
    public function setToTheOrderOf($toTheOrderOf = null)
    {
        // validation for constraint: string
        if (!is_null($toTheOrderOf) && !is_string($toTheOrderOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toTheOrderOf, true), gettype($toTheOrderOf)), __LINE__);
        }
        $this->toTheOrderOf = $toTheOrderOf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
