<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for skybillWithDimensionsValue StructType
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostSkybillWithDimensionsValue extends WsChronopostSkybillValue
{
    /**
     * The height
     * @var float
     */
    public $height;
    /**
     * The length
     * @var float
     */
    public $length;
    /**
     * The width
     * @var float
     */
    public $width;
    /**
     * Constructor method for skybillWithDimensionsValue
     * @uses WsChronopostSkybillWithDimensionsValue::setHeight()
     * @uses WsChronopostSkybillWithDimensionsValue::setLength()
     * @uses WsChronopostSkybillWithDimensionsValue::setWidth()
     * @param float $height
     * @param float $length
     * @param float $width
     */
    public function __construct($height = null, $length = null, $width = null)
    {
        $this
            ->setHeight($height)
            ->setLength($length)
            ->setWidth($width);
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValue
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValue
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValue
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
