<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingMultiParcelV4 StructType
 * Meta information extracted from the WSDL
 * - type: tns:shippingMultiParcelV4
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostShippingMultiParcelV4 extends AbstractStructBase
{
    /**
     * The esdValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostEsdValue3
     */
    public $esdValue;
    /**
     * The headerValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostHeaderValue
     */
    public $headerValue;
    /**
     * The shipperValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostShipperValueV2[]
     */
    public $shipperValue;
    /**
     * The customerValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostCustomerValue
     */
    public $customerValue;
    /**
     * The recipientValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRecipientValueV2[]
     */
    public $recipientValue;
    /**
     * The refValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRefValueV2[]
     */
    public $refValue;
    /**
     * The skybillValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6[]
     */
    public $skybillValue;
    /**
     * The skybillParamsValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostSkybillParamsValueV2
     */
    public $skybillParamsValue;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The modeRetour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $modeRetour;
    /**
     * The numberOfParcel
     * @var int
     */
    public $numberOfParcel;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * The multiParcel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $multiParcel;
    /**
     * The scheduledValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostScheduledValue[]
     */
    public $scheduledValue;
    /**
     * The recipientLocalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRecipientLocalValueV2[]
     */
    public $recipientLocalValue;
    /**
     * The customsValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostCustomsValue[]
     */
    public $customsValue;
    /**
     * Constructor method for shippingMultiParcelV4
     * @uses WsChronopostShippingMultiParcelV4::setEsdValue()
     * @uses WsChronopostShippingMultiParcelV4::setHeaderValue()
     * @uses WsChronopostShippingMultiParcelV4::setShipperValue()
     * @uses WsChronopostShippingMultiParcelV4::setCustomerValue()
     * @uses WsChronopostShippingMultiParcelV4::setRecipientValue()
     * @uses WsChronopostShippingMultiParcelV4::setRefValue()
     * @uses WsChronopostShippingMultiParcelV4::setSkybillValue()
     * @uses WsChronopostShippingMultiParcelV4::setSkybillParamsValue()
     * @uses WsChronopostShippingMultiParcelV4::setPassword()
     * @uses WsChronopostShippingMultiParcelV4::setModeRetour()
     * @uses WsChronopostShippingMultiParcelV4::setNumberOfParcel()
     * @uses WsChronopostShippingMultiParcelV4::setVersion()
     * @uses WsChronopostShippingMultiParcelV4::setMultiParcel()
     * @uses WsChronopostShippingMultiParcelV4::setScheduledValue()
     * @uses WsChronopostShippingMultiParcelV4::setRecipientLocalValue()
     * @uses WsChronopostShippingMultiParcelV4::setCustomsValue()
     * @param \WsChronopost\StructType\WsChronopostEsdValue3 $esdValue
     * @param \WsChronopost\StructType\WsChronopostHeaderValue $headerValue
     * @param \WsChronopost\StructType\WsChronopostShipperValueV2[] $shipperValue
     * @param \WsChronopost\StructType\WsChronopostCustomerValue $customerValue
     * @param \WsChronopost\StructType\WsChronopostRecipientValueV2[] $recipientValue
     * @param \WsChronopost\StructType\WsChronopostRefValueV2[] $refValue
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6[] $skybillValue
     * @param \WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue
     * @param string $password
     * @param string $modeRetour
     * @param int $numberOfParcel
     * @param string $version
     * @param string $multiParcel
     * @param \WsChronopost\StructType\WsChronopostScheduledValue[] $scheduledValue
     * @param \WsChronopost\StructType\WsChronopostRecipientLocalValueV2[] $recipientLocalValue
     * @param \WsChronopost\StructType\WsChronopostCustomsValue[] $customsValue
     */
    public function __construct(\WsChronopost\StructType\WsChronopostEsdValue3 $esdValue = null, \WsChronopost\StructType\WsChronopostHeaderValue $headerValue = null, array $shipperValue = array(), \WsChronopost\StructType\WsChronopostCustomerValue $customerValue = null, array $recipientValue = array(), array $refValue = array(), array $skybillValue = array(), \WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue = null, $password = null, $modeRetour = null, $numberOfParcel = null, $version = null, $multiParcel = null, array $scheduledValue = array(), array $recipientLocalValue = array(), array $customsValue = array())
    {
        $this
            ->setEsdValue($esdValue)
            ->setHeaderValue($headerValue)
            ->setShipperValue($shipperValue)
            ->setCustomerValue($customerValue)
            ->setRecipientValue($recipientValue)
            ->setRefValue($refValue)
            ->setSkybillValue($skybillValue)
            ->setSkybillParamsValue($skybillParamsValue)
            ->setPassword($password)
            ->setModeRetour($modeRetour)
            ->setNumberOfParcel($numberOfParcel)
            ->setVersion($version)
            ->setMultiParcel($multiParcel)
            ->setScheduledValue($scheduledValue)
            ->setRecipientLocalValue($recipientLocalValue)
            ->setCustomsValue($customsValue);
    }
    /**
     * Get esdValue value
     * @return \WsChronopost\StructType\WsChronopostEsdValue3|null
     */
    public function getEsdValue()
    {
        return $this->esdValue;
    }
    /**
     * Set esdValue value
     * @param \WsChronopost\StructType\WsChronopostEsdValue3 $esdValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setEsdValue(\WsChronopost\StructType\WsChronopostEsdValue3 $esdValue = null)
    {
        $this->esdValue = $esdValue;
        return $this;
    }
    /**
     * Get headerValue value
     * @return \WsChronopost\StructType\WsChronopostHeaderValue|null
     */
    public function getHeaderValue()
    {
        return $this->headerValue;
    }
    /**
     * Set headerValue value
     * @param \WsChronopost\StructType\WsChronopostHeaderValue $headerValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setHeaderValue(\WsChronopost\StructType\WsChronopostHeaderValue $headerValue = null)
    {
        $this->headerValue = $headerValue;
        return $this;
    }
    /**
     * Get shipperValue value
     * @return \WsChronopost\StructType\WsChronopostShipperValueV2[]|null
     */
    public function getShipperValue()
    {
        return $this->shipperValue;
    }
    /**
     * This method is responsible for validating the values passed to the setShipperValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipperValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipperValueForArrayConstraintsFromSetShipperValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV4ShipperValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV4ShipperValueItem instanceof \WsChronopost\StructType\WsChronopostShipperValueV2) {
                $invalidValues[] = is_object($shippingMultiParcelV4ShipperValueItem) ? get_class($shippingMultiParcelV4ShipperValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV4ShipperValueItem), var_export($shippingMultiParcelV4ShipperValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipperValue property can only contain items of type \WsChronopost\StructType\WsChronopostShipperValueV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipperValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostShipperValueV2[] $shipperValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setShipperValue(array $shipperValue = array())
    {
        // validation for constraint: array
        if ('' !== ($shipperValueArrayErrorMessage = self::validateShipperValueForArrayConstraintsFromSetShipperValue($shipperValue))) {
            throw new \InvalidArgumentException($shipperValueArrayErrorMessage, __LINE__);
        }
        $this->shipperValue = $shipperValue;
        return $this;
    }
    /**
     * Add item to shipperValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostShipperValueV2 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function addToShipperValue(\WsChronopost\StructType\WsChronopostShipperValueV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostShipperValueV2) {
            throw new \InvalidArgumentException(sprintf('The shipperValue property can only contain items of type \WsChronopost\StructType\WsChronopostShipperValueV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->shipperValue[] = $item;
        return $this;
    }
    /**
     * Get customerValue value
     * @return \WsChronopost\StructType\WsChronopostCustomerValue|null
     */
    public function getCustomerValue()
    {
        return $this->customerValue;
    }
    /**
     * Set customerValue value
     * @param \WsChronopost\StructType\WsChronopostCustomerValue $customerValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setCustomerValue(\WsChronopost\StructType\WsChronopostCustomerValue $customerValue = null)
    {
        $this->customerValue = $customerValue;
        return $this;
    }
    /**
     * Get recipientValue value
     * @return \WsChronopost\StructType\WsChronopostRecipientValueV2[]|null
     */
    public function getRecipientValue()
    {
        return $this->recipientValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientValueForArrayConstraintsFromSetRecipientValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV4RecipientValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV4RecipientValueItem instanceof \WsChronopost\StructType\WsChronopostRecipientValueV2) {
                $invalidValues[] = is_object($shippingMultiParcelV4RecipientValueItem) ? get_class($shippingMultiParcelV4RecipientValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV4RecipientValueItem), var_export($shippingMultiParcelV4RecipientValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recipientValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientValueV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recipientValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientValueV2[] $recipientValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setRecipientValue(array $recipientValue = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientValueArrayErrorMessage = self::validateRecipientValueForArrayConstraintsFromSetRecipientValue($recipientValue))) {
            throw new \InvalidArgumentException($recipientValueArrayErrorMessage, __LINE__);
        }
        $this->recipientValue = $recipientValue;
        return $this;
    }
    /**
     * Add item to recipientValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientValueV2 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function addToRecipientValue(\WsChronopost\StructType\WsChronopostRecipientValueV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRecipientValueV2) {
            throw new \InvalidArgumentException(sprintf('The recipientValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientValueV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recipientValue[] = $item;
        return $this;
    }
    /**
     * Get refValue value
     * @return \WsChronopost\StructType\WsChronopostRefValueV2[]|null
     */
    public function getRefValue()
    {
        return $this->refValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRefValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefValueForArrayConstraintsFromSetRefValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV4RefValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV4RefValueItem instanceof \WsChronopost\StructType\WsChronopostRefValueV2) {
                $invalidValues[] = is_object($shippingMultiParcelV4RefValueItem) ? get_class($shippingMultiParcelV4RefValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV4RefValueItem), var_export($shippingMultiParcelV4RefValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The refValue property can only contain items of type \WsChronopost\StructType\WsChronopostRefValueV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set refValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRefValueV2[] $refValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setRefValue(array $refValue = array())
    {
        // validation for constraint: array
        if ('' !== ($refValueArrayErrorMessage = self::validateRefValueForArrayConstraintsFromSetRefValue($refValue))) {
            throw new \InvalidArgumentException($refValueArrayErrorMessage, __LINE__);
        }
        $this->refValue = $refValue;
        return $this;
    }
    /**
     * Add item to refValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRefValueV2 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function addToRefValue(\WsChronopost\StructType\WsChronopostRefValueV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRefValueV2) {
            throw new \InvalidArgumentException(sprintf('The refValue property can only contain items of type \WsChronopost\StructType\WsChronopostRefValueV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->refValue[] = $item;
        return $this;
    }
    /**
     * Get skybillValue value
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6[]|null
     */
    public function getSkybillValue()
    {
        return $this->skybillValue;
    }
    /**
     * This method is responsible for validating the values passed to the setSkybillValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkybillValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkybillValueForArrayConstraintsFromSetSkybillValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV4SkybillValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV4SkybillValueItem instanceof \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6) {
                $invalidValues[] = is_object($shippingMultiParcelV4SkybillValueItem) ? get_class($shippingMultiParcelV4SkybillValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV4SkybillValueItem), var_export($shippingMultiParcelV4SkybillValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The skybillValue property can only contain items of type \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set skybillValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6[] $skybillValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setSkybillValue(array $skybillValue = array())
    {
        // validation for constraint: array
        if ('' !== ($skybillValueArrayErrorMessage = self::validateSkybillValueForArrayConstraintsFromSetSkybillValue($skybillValue))) {
            throw new \InvalidArgumentException($skybillValueArrayErrorMessage, __LINE__);
        }
        $this->skybillValue = $skybillValue;
        return $this;
    }
    /**
     * Add item to skybillValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function addToSkybillValue(\WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6) {
            throw new \InvalidArgumentException(sprintf('The skybillValue property can only contain items of type \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV6, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->skybillValue[] = $item;
        return $this;
    }
    /**
     * Get skybillParamsValue value
     * @return \WsChronopost\StructType\WsChronopostSkybillParamsValueV2|null
     */
    public function getSkybillParamsValue()
    {
        return $this->skybillParamsValue;
    }
    /**
     * Set skybillParamsValue value
     * @param \WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setSkybillParamsValue(\WsChronopost\StructType\WsChronopostSkybillParamsValueV2 $skybillParamsValue = null)
    {
        $this->skybillParamsValue = $skybillParamsValue;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get modeRetour value
     * @return string|null
     */
    public function getModeRetour()
    {
        return $this->modeRetour;
    }
    /**
     * Set modeRetour value
     * @param string $modeRetour
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setModeRetour($modeRetour = null)
    {
        // validation for constraint: string
        if (!is_null($modeRetour) && !is_string($modeRetour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeRetour, true), gettype($modeRetour)), __LINE__);
        }
        $this->modeRetour = $modeRetour;
        return $this;
    }
    /**
     * Get numberOfParcel value
     * @return int|null
     */
    public function getNumberOfParcel()
    {
        return $this->numberOfParcel;
    }
    /**
     * Set numberOfParcel value
     * @param int $numberOfParcel
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setNumberOfParcel($numberOfParcel = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfParcel) && !(is_int($numberOfParcel) || ctype_digit($numberOfParcel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfParcel, true), gettype($numberOfParcel)), __LINE__);
        }
        $this->numberOfParcel = $numberOfParcel;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get multiParcel value
     * @return string|null
     */
    public function getMultiParcel()
    {
        return $this->multiParcel;
    }
    /**
     * Set multiParcel value
     * @param string $multiParcel
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setMultiParcel($multiParcel = null)
    {
        // validation for constraint: string
        if (!is_null($multiParcel) && !is_string($multiParcel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multiParcel, true), gettype($multiParcel)), __LINE__);
        }
        $this->multiParcel = $multiParcel;
        return $this;
    }
    /**
     * Get scheduledValue value
     * @return \WsChronopost\StructType\WsChronopostScheduledValue[]|null
     */
    public function getScheduledValue()
    {
        return $this->scheduledValue;
    }
    /**
     * This method is responsible for validating the values passed to the setScheduledValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setScheduledValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateScheduledValueForArrayConstraintsFromSetScheduledValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV4ScheduledValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV4ScheduledValueItem instanceof \WsChronopost\StructType\WsChronopostScheduledValue) {
                $invalidValues[] = is_object($shippingMultiParcelV4ScheduledValueItem) ? get_class($shippingMultiParcelV4ScheduledValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV4ScheduledValueItem), var_export($shippingMultiParcelV4ScheduledValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The scheduledValue property can only contain items of type \WsChronopost\StructType\WsChronopostScheduledValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set scheduledValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostScheduledValue[] $scheduledValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setScheduledValue(array $scheduledValue = array())
    {
        // validation for constraint: array
        if ('' !== ($scheduledValueArrayErrorMessage = self::validateScheduledValueForArrayConstraintsFromSetScheduledValue($scheduledValue))) {
            throw new \InvalidArgumentException($scheduledValueArrayErrorMessage, __LINE__);
        }
        $this->scheduledValue = $scheduledValue;
        return $this;
    }
    /**
     * Add item to scheduledValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostScheduledValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function addToScheduledValue(\WsChronopost\StructType\WsChronopostScheduledValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostScheduledValue) {
            throw new \InvalidArgumentException(sprintf('The scheduledValue property can only contain items of type \WsChronopost\StructType\WsChronopostScheduledValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->scheduledValue[] = $item;
        return $this;
    }
    /**
     * Get recipientLocalValue value
     * @return \WsChronopost\StructType\WsChronopostRecipientLocalValueV2[]|null
     */
    public function getRecipientLocalValue()
    {
        return $this->recipientLocalValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientLocalValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientLocalValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientLocalValueForArrayConstraintsFromSetRecipientLocalValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV4RecipientLocalValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV4RecipientLocalValueItem instanceof \WsChronopost\StructType\WsChronopostRecipientLocalValueV2) {
                $invalidValues[] = is_object($shippingMultiParcelV4RecipientLocalValueItem) ? get_class($shippingMultiParcelV4RecipientLocalValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV4RecipientLocalValueItem), var_export($shippingMultiParcelV4RecipientLocalValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recipientLocalValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientLocalValueV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recipientLocalValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientLocalValueV2[] $recipientLocalValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setRecipientLocalValue(array $recipientLocalValue = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientLocalValueArrayErrorMessage = self::validateRecipientLocalValueForArrayConstraintsFromSetRecipientLocalValue($recipientLocalValue))) {
            throw new \InvalidArgumentException($recipientLocalValueArrayErrorMessage, __LINE__);
        }
        $this->recipientLocalValue = $recipientLocalValue;
        return $this;
    }
    /**
     * Add item to recipientLocalValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientLocalValueV2 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function addToRecipientLocalValue(\WsChronopost\StructType\WsChronopostRecipientLocalValueV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRecipientLocalValueV2) {
            throw new \InvalidArgumentException(sprintf('The recipientLocalValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientLocalValueV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recipientLocalValue[] = $item;
        return $this;
    }
    /**
     * Get customsValue value
     * @return \WsChronopost\StructType\WsChronopostCustomsValue[]|null
     */
    public function getCustomsValue()
    {
        return $this->customsValue;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomsValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsValueForArrayConstraintsFromSetCustomsValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelV4CustomsValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelV4CustomsValueItem instanceof \WsChronopost\StructType\WsChronopostCustomsValue) {
                $invalidValues[] = is_object($shippingMultiParcelV4CustomsValueItem) ? get_class($shippingMultiParcelV4CustomsValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelV4CustomsValueItem), var_export($shippingMultiParcelV4CustomsValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customsValue property can only contain items of type \WsChronopost\StructType\WsChronopostCustomsValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customsValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostCustomsValue[] $customsValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function setCustomsValue(array $customsValue = array())
    {
        // validation for constraint: array
        if ('' !== ($customsValueArrayErrorMessage = self::validateCustomsValueForArrayConstraintsFromSetCustomsValue($customsValue))) {
            throw new \InvalidArgumentException($customsValueArrayErrorMessage, __LINE__);
        }
        $this->customsValue = $customsValue;
        return $this;
    }
    /**
     * Add item to customsValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostCustomsValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public function addToCustomsValue(\WsChronopost\StructType\WsChronopostCustomsValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostCustomsValue) {
            throw new \InvalidArgumentException(sprintf('The customsValue property can only contain items of type \WsChronopost\StructType\WsChronopostCustomsValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customsValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
