<?php

namespace WsChronopost\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Shipping ServiceType
 * @package WsChronopost
 * @subpackage Services
 */
class WsChronopostShipping extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named shippingV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingV2 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingV2Response|bool
     */
    public function shippingV2(\WsChronopost\StructType\WsChronopostShippingV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingV3 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingV3Response|bool
     */
    public function shippingV3(\WsChronopost\StructType\WsChronopostShippingV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingMultiParcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingMultiParcel $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelResponse|bool
     */
    public function shippingMultiParcel(\WsChronopost\StructType\WsChronopostShippingMultiParcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingMultiParcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingWithReservationV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingWithReservationV2 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingWithReservationV2Response|bool
     */
    public function shippingWithReservationV2(\WsChronopost\StructType\WsChronopostShippingWithReservationV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingWithReservationV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shipping
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShipping $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingResponse|bool
     */
    public function shipping(\WsChronopost\StructType\WsChronopostShipping $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shipping($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingMultiParcelWithReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservation $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationResponse|bool
     */
    public function shippingMultiParcelWithReservation(\WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingMultiParcelWithReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingMultiParcelV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingMultiParcelV4 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV4Response|bool
     */
    public function shippingMultiParcelV4(\WsChronopost\StructType\WsChronopostShippingMultiParcelV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingMultiParcelV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * shippingMultiParcelWithReservationV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV3 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV3Response|bool
     */
    public function shippingMultiParcelWithReservationV3(\WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingMultiParcelWithReservationV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingMultiParcelV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingMultiParcelV2 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV2Response|bool
     */
    public function shippingMultiParcelV2(\WsChronopost\StructType\WsChronopostShippingMultiParcelV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingMultiParcelV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingV6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingV6 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingV6Response|bool
     */
    public function shippingV6(\WsChronopost\StructType\WsChronopostShippingV6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingV6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingWithReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingWithReservation $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingWithReservationResponse|bool
     */
    public function shippingWithReservation(\WsChronopost\StructType\WsChronopostShippingWithReservation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingWithReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingV7
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingV7 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingV7Response|bool
     */
    public function shippingV7(\WsChronopost\StructType\WsChronopostShippingV7 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingV7($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * shippingWithReservationAndESDWithRefClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClient $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClientResponse|bool
     */
    public function shippingWithReservationAndESDWithRefClient(\WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClient $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingWithReservationAndESDWithRefClient($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingV4 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingV4Response|bool
     */
    public function shippingV4(\WsChronopost\StructType\WsChronopostShippingV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingV5
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingV5 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingV5Response|bool
     */
    public function shippingV5(\WsChronopost\StructType\WsChronopostShippingV5 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingV5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * shippingWithReservationAndESDWithRefClientPC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClientPC $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClientPCResponse|bool
     */
    public function shippingWithReservationAndESDWithRefClientPC(\WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClientPC $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingWithReservationAndESDWithRefClientPC($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * shippingMultiParcelWithReservationV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2Response|bool
     */
    public function shippingMultiParcelWithReservationV2(\WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingMultiParcelWithReservationV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingWithESDOnly
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingWithESDOnly $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingWithESDOnlyResponse|bool
     */
    public function shippingWithESDOnly(\WsChronopost\StructType\WsChronopostShippingWithESDOnly $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingWithESDOnly($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named shippingMultiParcelV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostShippingMultiParcelV3 $parameters
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelV3Response|bool
     */
    public function shippingMultiParcelV3(\WsChronopost\StructType\WsChronopostShippingMultiParcelV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->shippingMultiParcelV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelResponse|\WsChronopost\StructType\WsChronopostShippingMultiParcelV2Response|\WsChronopost\StructType\WsChronopostShippingMultiParcelV3Response|\WsChronopost\StructType\WsChronopostShippingMultiParcelV4Response|\WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationResponse|\WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2Response|\WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV3Response|\WsChronopost\StructType\WsChronopostShippingResponse|\WsChronopost\StructType\WsChronopostShippingV2Response|\WsChronopost\StructType\WsChronopostShippingV3Response|\WsChronopost\StructType\WsChronopostShippingV4Response|\WsChronopost\StructType\WsChronopostShippingV5Response|\WsChronopost\StructType\WsChronopostShippingV6Response|\WsChronopost\StructType\WsChronopostShippingV7Response|\WsChronopost\StructType\WsChronopostShippingWithESDOnlyResponse|\WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClientPCResponse|\WsChronopost\StructType\WsChronopostShippingWithReservationAndESDWithRefClientResponse|\WsChronopost\StructType\WsChronopostShippingWithReservationResponse|\WsChronopost\StructType\WsChronopostShippingWithReservationV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
