<?php

namespace WsChronopost\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package WsChronopost
 * @subpackage Services
 */
class WsChronopostGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getReservedSkybillWithType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostGetReservedSkybillWithType $parameters
     * @return \WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeResponse|bool
     */
    public function getReservedSkybillWithType(\WsChronopost\StructType\WsChronopostGetReservedSkybillWithType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReservedSkybillWithType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getReservedSkybillWithTypeAndModeAuth
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeAuth $parameters
     * @return \WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeAuthResponse|bool
     */
    public function getReservedSkybillWithTypeAndModeAuth(\WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeAuth $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReservedSkybillWithTypeAndModeAuth($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getReservedSkybillWithTypeAndModeByReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeByReservation $parameters
     * @return \WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeByReservationResponse|bool
     */
    public function getReservedSkybillWithTypeAndModeByReservation(\WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeByReservation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReservedSkybillWithTypeAndModeByReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReservedSkybill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostGetReservedSkybill $parameters
     * @return \WsChronopost\StructType\WsChronopostGetReservedSkybillResponse|bool
     */
    public function getReservedSkybill(\WsChronopost\StructType\WsChronopostGetReservedSkybill $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReservedSkybill($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReservedSkybillWithTypeAndMode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndMode $parameters
     * @return \WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeResponse|bool
     */
    public function getReservedSkybillWithTypeAndMode(\WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndMode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getReservedSkybillWithTypeAndMode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getShippingInformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostGetShippingInformation $parameters
     * @return \WsChronopost\StructType\WsChronopostGetShippingInformationResponse|bool
     */
    public function getShippingInformation(\WsChronopost\StructType\WsChronopostGetShippingInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getShippingInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostGetRouting $parameters
     * @return \WsChronopost\StructType\WsChronopostGetRoutingResponse|bool
     */
    public function getRouting(\WsChronopost\StructType\WsChronopostGetRouting $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRouting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WsChronopost\StructType\WsChronopostGetReservedSkybillResponse|\WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeAuthResponse|\WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeByReservationResponse|\WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeAndModeResponse|\WsChronopost\StructType\WsChronopostGetReservedSkybillWithTypeResponse|\WsChronopost\StructType\WsChronopostGetRoutingResponse|\WsChronopost\StructType\WsChronopostGetShippingInformationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
