<?php

namespace WsChronopost\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Creer ServiceType
 * @package WsChronopost
 * @subpackage Services
 */
class WsChronopostCreer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named creerEnlevementNational
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostCreerEnlevementNational $parameters
     * @return \WsChronopost\StructType\WsChronopostCreerEnlevementNationalResponse|bool
     */
    public function creerEnlevementNational(\WsChronopost\StructType\WsChronopostCreerEnlevementNational $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->creerEnlevementNational($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named creerEnlevementEurope
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostCreerEnlevementEurope $parameters
     * @return \WsChronopost\StructType\WsChronopostCreerEnlevementEuropeResponse|bool
     */
    public function creerEnlevementEurope(\WsChronopost\StructType\WsChronopostCreerEnlevementEurope $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->creerEnlevementEurope($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WsChronopost\StructType\WsChronopostCreerEnlevementEuropeResponse|\WsChronopost\StructType\WsChronopostCreerEnlevementNationalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
