<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shippingMultiParcelWithReservationV2 StructType
 * Meta information extracted from the WSDL
 * - type: tns:shippingMultiParcelWithReservationV2
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostShippingMultiParcelWithReservationV2 extends AbstractStructBase
{
    /**
     * The esdValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostEsdWithRefClientValue
     */
    public $esdValue;
    /**
     * The headerValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostHeaderValue
     */
    public $headerValue;
    /**
     * The shipperValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostShipperValue
     */
    public $shipperValue;
    /**
     * The customerValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostCustomerValue
     */
    public $customerValue;
    /**
     * The recipientValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRecipientValue[]
     */
    public $recipientValue;
    /**
     * The refValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostRefValue[]
     */
    public $refValue;
    /**
     * The skybillValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2[]
     */
    public $skybillValue;
    /**
     * The skybillParamsValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostSkybillParamsValue
     */
    public $skybillParamsValue;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The modeRetour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $modeRetour;
    /**
     * The numberOfParcel
     * @var int
     */
    public $numberOfParcel;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * The multiParcel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $multiParcel;
    /**
     * The scheduledValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostScheduledValue
     */
    public $scheduledValue;
    /**
     * Constructor method for shippingMultiParcelWithReservationV2
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setEsdValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setHeaderValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setShipperValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setCustomerValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setRecipientValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setRefValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setSkybillValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setSkybillParamsValue()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setPassword()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setModeRetour()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setNumberOfParcel()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setVersion()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setMultiParcel()
     * @uses WsChronopostShippingMultiParcelWithReservationV2::setScheduledValue()
     * @param \WsChronopost\StructType\WsChronopostEsdWithRefClientValue $esdValue
     * @param \WsChronopost\StructType\WsChronopostHeaderValue $headerValue
     * @param \WsChronopost\StructType\WsChronopostShipperValue $shipperValue
     * @param \WsChronopost\StructType\WsChronopostCustomerValue $customerValue
     * @param \WsChronopost\StructType\WsChronopostRecipientValue[] $recipientValue
     * @param \WsChronopost\StructType\WsChronopostRefValue[] $refValue
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2[] $skybillValue
     * @param \WsChronopost\StructType\WsChronopostSkybillParamsValue $skybillParamsValue
     * @param string $password
     * @param string $modeRetour
     * @param int $numberOfParcel
     * @param string $version
     * @param string $multiParcel
     * @param \WsChronopost\StructType\WsChronopostScheduledValue $scheduledValue
     */
    public function __construct(\WsChronopost\StructType\WsChronopostEsdWithRefClientValue $esdValue = null, \WsChronopost\StructType\WsChronopostHeaderValue $headerValue = null, \WsChronopost\StructType\WsChronopostShipperValue $shipperValue = null, \WsChronopost\StructType\WsChronopostCustomerValue $customerValue = null, array $recipientValue = array(), array $refValue = array(), array $skybillValue = array(), \WsChronopost\StructType\WsChronopostSkybillParamsValue $skybillParamsValue = null, $password = null, $modeRetour = null, $numberOfParcel = null, $version = null, $multiParcel = null, \WsChronopost\StructType\WsChronopostScheduledValue $scheduledValue = null)
    {
        $this
            ->setEsdValue($esdValue)
            ->setHeaderValue($headerValue)
            ->setShipperValue($shipperValue)
            ->setCustomerValue($customerValue)
            ->setRecipientValue($recipientValue)
            ->setRefValue($refValue)
            ->setSkybillValue($skybillValue)
            ->setSkybillParamsValue($skybillParamsValue)
            ->setPassword($password)
            ->setModeRetour($modeRetour)
            ->setNumberOfParcel($numberOfParcel)
            ->setVersion($version)
            ->setMultiParcel($multiParcel)
            ->setScheduledValue($scheduledValue);
    }
    /**
     * Get esdValue value
     * @return \WsChronopost\StructType\WsChronopostEsdWithRefClientValue|null
     */
    public function getEsdValue()
    {
        return $this->esdValue;
    }
    /**
     * Set esdValue value
     * @param \WsChronopost\StructType\WsChronopostEsdWithRefClientValue $esdValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setEsdValue(\WsChronopost\StructType\WsChronopostEsdWithRefClientValue $esdValue = null)
    {
        $this->esdValue = $esdValue;
        return $this;
    }
    /**
     * Get headerValue value
     * @return \WsChronopost\StructType\WsChronopostHeaderValue|null
     */
    public function getHeaderValue()
    {
        return $this->headerValue;
    }
    /**
     * Set headerValue value
     * @param \WsChronopost\StructType\WsChronopostHeaderValue $headerValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setHeaderValue(\WsChronopost\StructType\WsChronopostHeaderValue $headerValue = null)
    {
        $this->headerValue = $headerValue;
        return $this;
    }
    /**
     * Get shipperValue value
     * @return \WsChronopost\StructType\WsChronopostShipperValue|null
     */
    public function getShipperValue()
    {
        return $this->shipperValue;
    }
    /**
     * Set shipperValue value
     * @param \WsChronopost\StructType\WsChronopostShipperValue $shipperValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setShipperValue(\WsChronopost\StructType\WsChronopostShipperValue $shipperValue = null)
    {
        $this->shipperValue = $shipperValue;
        return $this;
    }
    /**
     * Get customerValue value
     * @return \WsChronopost\StructType\WsChronopostCustomerValue|null
     */
    public function getCustomerValue()
    {
        return $this->customerValue;
    }
    /**
     * Set customerValue value
     * @param \WsChronopost\StructType\WsChronopostCustomerValue $customerValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setCustomerValue(\WsChronopost\StructType\WsChronopostCustomerValue $customerValue = null)
    {
        $this->customerValue = $customerValue;
        return $this;
    }
    /**
     * Get recipientValue value
     * @return \WsChronopost\StructType\WsChronopostRecipientValue[]|null
     */
    public function getRecipientValue()
    {
        return $this->recipientValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipientValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipientValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipientValueForArrayConstraintsFromSetRecipientValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelWithReservationV2RecipientValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelWithReservationV2RecipientValueItem instanceof \WsChronopost\StructType\WsChronopostRecipientValue) {
                $invalidValues[] = is_object($shippingMultiParcelWithReservationV2RecipientValueItem) ? get_class($shippingMultiParcelWithReservationV2RecipientValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelWithReservationV2RecipientValueItem), var_export($shippingMultiParcelWithReservationV2RecipientValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recipientValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recipientValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientValue[] $recipientValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setRecipientValue(array $recipientValue = array())
    {
        // validation for constraint: array
        if ('' !== ($recipientValueArrayErrorMessage = self::validateRecipientValueForArrayConstraintsFromSetRecipientValue($recipientValue))) {
            throw new \InvalidArgumentException($recipientValueArrayErrorMessage, __LINE__);
        }
        $this->recipientValue = $recipientValue;
        return $this;
    }
    /**
     * Add item to recipientValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRecipientValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function addToRecipientValue(\WsChronopost\StructType\WsChronopostRecipientValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRecipientValue) {
            throw new \InvalidArgumentException(sprintf('The recipientValue property can only contain items of type \WsChronopost\StructType\WsChronopostRecipientValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recipientValue[] = $item;
        return $this;
    }
    /**
     * Get refValue value
     * @return \WsChronopost\StructType\WsChronopostRefValue[]|null
     */
    public function getRefValue()
    {
        return $this->refValue;
    }
    /**
     * This method is responsible for validating the values passed to the setRefValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefValueForArrayConstraintsFromSetRefValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelWithReservationV2RefValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelWithReservationV2RefValueItem instanceof \WsChronopost\StructType\WsChronopostRefValue) {
                $invalidValues[] = is_object($shippingMultiParcelWithReservationV2RefValueItem) ? get_class($shippingMultiParcelWithReservationV2RefValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelWithReservationV2RefValueItem), var_export($shippingMultiParcelWithReservationV2RefValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The refValue property can only contain items of type \WsChronopost\StructType\WsChronopostRefValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set refValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRefValue[] $refValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setRefValue(array $refValue = array())
    {
        // validation for constraint: array
        if ('' !== ($refValueArrayErrorMessage = self::validateRefValueForArrayConstraintsFromSetRefValue($refValue))) {
            throw new \InvalidArgumentException($refValueArrayErrorMessage, __LINE__);
        }
        $this->refValue = $refValue;
        return $this;
    }
    /**
     * Add item to refValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostRefValue $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function addToRefValue(\WsChronopost\StructType\WsChronopostRefValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostRefValue) {
            throw new \InvalidArgumentException(sprintf('The refValue property can only contain items of type \WsChronopost\StructType\WsChronopostRefValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->refValue[] = $item;
        return $this;
    }
    /**
     * Get skybillValue value
     * @return \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2[]|null
     */
    public function getSkybillValue()
    {
        return $this->skybillValue;
    }
    /**
     * This method is responsible for validating the values passed to the setSkybillValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSkybillValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSkybillValueForArrayConstraintsFromSetSkybillValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shippingMultiParcelWithReservationV2SkybillValueItem) {
            // validation for constraint: itemType
            if (!$shippingMultiParcelWithReservationV2SkybillValueItem instanceof \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2) {
                $invalidValues[] = is_object($shippingMultiParcelWithReservationV2SkybillValueItem) ? get_class($shippingMultiParcelWithReservationV2SkybillValueItem) : sprintf('%s(%s)', gettype($shippingMultiParcelWithReservationV2SkybillValueItem), var_export($shippingMultiParcelWithReservationV2SkybillValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The skybillValue property can only contain items of type \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set skybillValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2[] $skybillValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setSkybillValue(array $skybillValue = array())
    {
        // validation for constraint: array
        if ('' !== ($skybillValueArrayErrorMessage = self::validateSkybillValueForArrayConstraintsFromSetSkybillValue($skybillValue))) {
            throw new \InvalidArgumentException($skybillValueArrayErrorMessage, __LINE__);
        }
        $this->skybillValue = $skybillValue;
        return $this;
    }
    /**
     * Add item to skybillValue value
     * @throws \InvalidArgumentException
     * @param \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2 $item
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function addToSkybillValue(\WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2) {
            throw new \InvalidArgumentException(sprintf('The skybillValue property can only contain items of type \WsChronopost\StructType\WsChronopostSkybillWithDimensionsValueV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->skybillValue[] = $item;
        return $this;
    }
    /**
     * Get skybillParamsValue value
     * @return \WsChronopost\StructType\WsChronopostSkybillParamsValue|null
     */
    public function getSkybillParamsValue()
    {
        return $this->skybillParamsValue;
    }
    /**
     * Set skybillParamsValue value
     * @param \WsChronopost\StructType\WsChronopostSkybillParamsValue $skybillParamsValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setSkybillParamsValue(\WsChronopost\StructType\WsChronopostSkybillParamsValue $skybillParamsValue = null)
    {
        $this->skybillParamsValue = $skybillParamsValue;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get modeRetour value
     * @return string|null
     */
    public function getModeRetour()
    {
        return $this->modeRetour;
    }
    /**
     * Set modeRetour value
     * @param string $modeRetour
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setModeRetour($modeRetour = null)
    {
        // validation for constraint: string
        if (!is_null($modeRetour) && !is_string($modeRetour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeRetour, true), gettype($modeRetour)), __LINE__);
        }
        $this->modeRetour = $modeRetour;
        return $this;
    }
    /**
     * Get numberOfParcel value
     * @return int|null
     */
    public function getNumberOfParcel()
    {
        return $this->numberOfParcel;
    }
    /**
     * Set numberOfParcel value
     * @param int $numberOfParcel
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setNumberOfParcel($numberOfParcel = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfParcel) && !(is_int($numberOfParcel) || ctype_digit($numberOfParcel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfParcel, true), gettype($numberOfParcel)), __LINE__);
        }
        $this->numberOfParcel = $numberOfParcel;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get multiParcel value
     * @return string|null
     */
    public function getMultiParcel()
    {
        return $this->multiParcel;
    }
    /**
     * Set multiParcel value
     * @param string $multiParcel
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setMultiParcel($multiParcel = null)
    {
        // validation for constraint: string
        if (!is_null($multiParcel) && !is_string($multiParcel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multiParcel, true), gettype($multiParcel)), __LINE__);
        }
        $this->multiParcel = $multiParcel;
        return $this;
    }
    /**
     * Get scheduledValue value
     * @return \WsChronopost\StructType\WsChronopostScheduledValue|null
     */
    public function getScheduledValue()
    {
        return $this->scheduledValue;
    }
    /**
     * Set scheduledValue value
     * @param \WsChronopost\StructType\WsChronopostScheduledValue $scheduledValue
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public function setScheduledValue(\WsChronopost\StructType\WsChronopostScheduledValue $scheduledValue = null)
    {
        $this->scheduledValue = $scheduledValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostShippingMultiParcelWithReservationV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
