<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for scheduledValue StructType
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostScheduledValue extends AbstractStructBase
{
    /**
     * The appointmentValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostAppointmentValue
     */
    public $appointmentValue;
    /**
     * The expirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The sellByDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sellByDate;
    /**
     * Constructor method for scheduledValue
     * @uses WsChronopostScheduledValue::setAppointmentValue()
     * @uses WsChronopostScheduledValue::setExpirationDate()
     * @uses WsChronopostScheduledValue::setSellByDate()
     * @param \WsChronopost\StructType\WsChronopostAppointmentValue $appointmentValue
     * @param string $expirationDate
     * @param string $sellByDate
     */
    public function __construct(\WsChronopost\StructType\WsChronopostAppointmentValue $appointmentValue = null, $expirationDate = null, $sellByDate = null)
    {
        $this
            ->setAppointmentValue($appointmentValue)
            ->setExpirationDate($expirationDate)
            ->setSellByDate($sellByDate);
    }
    /**
     * Get appointmentValue value
     * @return \WsChronopost\StructType\WsChronopostAppointmentValue|null
     */
    public function getAppointmentValue()
    {
        return $this->appointmentValue;
    }
    /**
     * Set appointmentValue value
     * @param \WsChronopost\StructType\WsChronopostAppointmentValue $appointmentValue
     * @return \WsChronopost\StructType\WsChronopostScheduledValue
     */
    public function setAppointmentValue(\WsChronopost\StructType\WsChronopostAppointmentValue $appointmentValue = null)
    {
        $this->appointmentValue = $appointmentValue;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \WsChronopost\StructType\WsChronopostScheduledValue
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get sellByDate value
     * @return string|null
     */
    public function getSellByDate()
    {
        return $this->sellByDate;
    }
    /**
     * Set sellByDate value
     * @param string $sellByDate
     * @return \WsChronopost\StructType\WsChronopostScheduledValue
     */
    public function setSellByDate($sellByDate = null)
    {
        // validation for constraint: string
        if (!is_null($sellByDate) && !is_string($sellByDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellByDate, true), gettype($sellByDate)), __LINE__);
        }
        $this->sellByDate = $sellByDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostScheduledValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
