<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resultGetRouting StructType
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostResultGetRouting extends AbstractStructBase
{
    /**
     * The errorCode
     * @var int
     */
    public $errorCode;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The geopostResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \WsChronopost\StructType\WsChronopostGeopostResult
     */
    public $geopostResult;
    /**
     * The posteComptable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $posteComptable;
    /**
     * Constructor method for resultGetRouting
     * @uses WsChronopostResultGetRouting::setErrorCode()
     * @uses WsChronopostResultGetRouting::setErrorMessage()
     * @uses WsChronopostResultGetRouting::setGeopostResult()
     * @uses WsChronopostResultGetRouting::setPosteComptable()
     * @param int $errorCode
     * @param string $errorMessage
     * @param \WsChronopost\StructType\WsChronopostGeopostResult $geopostResult
     * @param string $posteComptable
     */
    public function __construct($errorCode = null, $errorMessage = null, \WsChronopost\StructType\WsChronopostGeopostResult $geopostResult = null, $posteComptable = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setErrorMessage($errorMessage)
            ->setGeopostResult($geopostResult)
            ->setPosteComptable($posteComptable);
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \WsChronopost\StructType\WsChronopostResultGetRouting
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \WsChronopost\StructType\WsChronopostResultGetRouting
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get geopostResult value
     * @return \WsChronopost\StructType\WsChronopostGeopostResult|null
     */
    public function getGeopostResult()
    {
        return $this->geopostResult;
    }
    /**
     * Set geopostResult value
     * @param \WsChronopost\StructType\WsChronopostGeopostResult $geopostResult
     * @return \WsChronopost\StructType\WsChronopostResultGetRouting
     */
    public function setGeopostResult(\WsChronopost\StructType\WsChronopostGeopostResult $geopostResult = null)
    {
        $this->geopostResult = $geopostResult;
        return $this;
    }
    /**
     * Get posteComptable value
     * @return string|null
     */
    public function getPosteComptable()
    {
        return $this->posteComptable;
    }
    /**
     * Set posteComptable value
     * @param string $posteComptable
     * @return \WsChronopost\StructType\WsChronopostResultGetRouting
     */
    public function setPosteComptable($posteComptable = null)
    {
        // validation for constraint: string
        if (!is_null($posteComptable) && !is_string($posteComptable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posteComptable, true), gettype($posteComptable)), __LINE__);
        }
        $this->posteComptable = $posteComptable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostResultGetRouting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
