<?php

namespace WsChronopost\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for recipientLocalValue StructType
 * @package WsChronopost
 * @subpackage Structs
 */
class WsChronopostRecipientLocalValue extends WsChronopostRecipientValue
{
    /**
     * The identityCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $identityCardNumber;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The province
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $province;
    /**
     * Constructor method for recipientLocalValue
     * @uses WsChronopostRecipientLocalValue::setIdentityCardNumber()
     * @uses WsChronopostRecipientLocalValue::setLanguage()
     * @uses WsChronopostRecipientLocalValue::setProvince()
     * @param string $identityCardNumber
     * @param string $language
     * @param string $province
     */
    public function __construct($identityCardNumber = null, $language = null, $province = null)
    {
        $this
            ->setIdentityCardNumber($identityCardNumber)
            ->setLanguage($language)
            ->setProvince($province);
    }
    /**
     * Get identityCardNumber value
     * @return string|null
     */
    public function getIdentityCardNumber()
    {
        return $this->identityCardNumber;
    }
    /**
     * Set identityCardNumber value
     * @param string $identityCardNumber
     * @return \WsChronopost\StructType\WsChronopostRecipientLocalValue
     */
    public function setIdentityCardNumber($identityCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identityCardNumber) && !is_string($identityCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityCardNumber, true), gettype($identityCardNumber)), __LINE__);
        }
        $this->identityCardNumber = $identityCardNumber;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \WsChronopost\StructType\WsChronopostRecipientLocalValue
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get province value
     * @return string|null
     */
    public function getProvince()
    {
        return $this->province;
    }
    /**
     * Set province value
     * @param string $province
     * @return \WsChronopost\StructType\WsChronopostRecipientLocalValue
     */
    public function setProvince($province = null)
    {
        // validation for constraint: string
        if (!is_null($province) && !is_string($province)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($province, true), gettype($province)), __LINE__);
        }
        $this->province = $province;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WsChronopost\StructType\WsChronopostRecipientLocalValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
