<?php

namespace WsChronopost\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rechercher ServiceType
 * @package WsChronopost
 * @subpackage Services
 */
class WsChronopostRechercher extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named rechercherContraintesEnlevement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \WsChronopost\StructType\WsChronopostRechercherContraintesEnlevement $parameters
     * @return \WsChronopost\StructType\WsChronopostRechercherContraintesEnlevementResponse|bool
     */
    public function rechercherContraintesEnlevement(\WsChronopost\StructType\WsChronopostRechercherContraintesEnlevement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->rechercherContraintesEnlevement($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \WsChronopost\StructType\WsChronopostRechercherContraintesEnlevementResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
