<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomsData
 * @subpackage Structs
 */
class CustomsData extends AbstractStructBase
{
    /**
     * The ClientCustomsCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCustomsCode;
    /**
     * The ComercialInvoice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComercialInvoice;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The CustomsItemsData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomsItemsData
     */
    public $CustomsItemsData;
    /**
     * The CustomsTotalItems
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomsTotalItems;
    /**
     * The CustomsTotalValue
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomsTotalValue;
    /**
     * The CustomsTotalWeight
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomsTotalWeight;
    /**
     * The ExportLicence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExportLicence;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Height;
    /**
     * The InsurancePremium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsurancePremium;
    /**
     * The InsuranceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsuranceValue;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Length;
    /**
     * The NonDeliveryCase
     * @var string
     */
    public $NonDeliveryCase;
    /**
     * The OriginCertificateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginCertificateNumber;
    /**
     * The ReceiverTIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverTIN;
    /**
     * The SachetDocumentation
     * @var bool
     */
    public $SachetDocumentation;
    /**
     * The SenderEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderEmail;
    /**
     * The ServiceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceValue;
    /**
     * The VATExportDeclaration
     * @var bool
     */
    public $VATExportDeclaration;
    /**
     * The VATRate
     * @var bool
     */
    public $VATRate;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Width;
    /**
     * Constructor method for CustomsData
     * @uses CustomsData::setClientCustomsCode()
     * @uses CustomsData::setComercialInvoice()
     * @uses CustomsData::setComments()
     * @uses CustomsData::setCustomsItemsData()
     * @uses CustomsData::setCustomsTotalItems()
     * @uses CustomsData::setCustomsTotalValue()
     * @uses CustomsData::setCustomsTotalWeight()
     * @uses CustomsData::setExportLicence()
     * @uses CustomsData::setHeight()
     * @uses CustomsData::setInsurancePremium()
     * @uses CustomsData::setInsuranceValue()
     * @uses CustomsData::setLength()
     * @uses CustomsData::setNonDeliveryCase()
     * @uses CustomsData::setOriginCertificateNumber()
     * @uses CustomsData::setReceiverTIN()
     * @uses CustomsData::setSachetDocumentation()
     * @uses CustomsData::setSenderEmail()
     * @uses CustomsData::setServiceValue()
     * @uses CustomsData::setVATExportDeclaration()
     * @uses CustomsData::setVATRate()
     * @uses CustomsData::setWidth()
     * @param string $clientCustomsCode
     * @param string $comercialInvoice
     * @param string $comments
     * @param \ArrayType\ArrayOfCustomsItemsData $customsItemsData
     * @param string $customsTotalItems
     * @param string $customsTotalValue
     * @param string $customsTotalWeight
     * @param string $exportLicence
     * @param string $height
     * @param string $insurancePremium
     * @param string $insuranceValue
     * @param string $length
     * @param string $nonDeliveryCase
     * @param string $originCertificateNumber
     * @param string $receiverTIN
     * @param bool $sachetDocumentation
     * @param string $senderEmail
     * @param string $serviceValue
     * @param bool $vATExportDeclaration
     * @param bool $vATRate
     * @param string $width
     */
    public function __construct($clientCustomsCode = null, $comercialInvoice = null, $comments = null, \ArrayType\ArrayOfCustomsItemsData $customsItemsData = null, $customsTotalItems = null, $customsTotalValue = null, $customsTotalWeight = null, $exportLicence = null, $height = null, $insurancePremium = null, $insuranceValue = null, $length = null, $nonDeliveryCase = null, $originCertificateNumber = null, $receiverTIN = null, $sachetDocumentation = null, $senderEmail = null, $serviceValue = null, $vATExportDeclaration = null, $vATRate = null, $width = null)
    {
        $this
            ->setClientCustomsCode($clientCustomsCode)
            ->setComercialInvoice($comercialInvoice)
            ->setComments($comments)
            ->setCustomsItemsData($customsItemsData)
            ->setCustomsTotalItems($customsTotalItems)
            ->setCustomsTotalValue($customsTotalValue)
            ->setCustomsTotalWeight($customsTotalWeight)
            ->setExportLicence($exportLicence)
            ->setHeight($height)
            ->setInsurancePremium($insurancePremium)
            ->setInsuranceValue($insuranceValue)
            ->setLength($length)
            ->setNonDeliveryCase($nonDeliveryCase)
            ->setOriginCertificateNumber($originCertificateNumber)
            ->setReceiverTIN($receiverTIN)
            ->setSachetDocumentation($sachetDocumentation)
            ->setSenderEmail($senderEmail)
            ->setServiceValue($serviceValue)
            ->setVATExportDeclaration($vATExportDeclaration)
            ->setVATRate($vATRate)
            ->setWidth($width);
    }
    /**
     * Get ClientCustomsCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCustomsCode()
    {
        return isset($this->ClientCustomsCode) ? $this->ClientCustomsCode : null;
    }
    /**
     * Set ClientCustomsCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCustomsCode
     * @return \StructType\CustomsData
     */
    public function setClientCustomsCode($clientCustomsCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCustomsCode) && !is_string($clientCustomsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCustomsCode, true), gettype($clientCustomsCode)), __LINE__);
        }
        if (is_null($clientCustomsCode) || (is_array($clientCustomsCode) && empty($clientCustomsCode))) {
            unset($this->ClientCustomsCode);
        } else {
            $this->ClientCustomsCode = $clientCustomsCode;
        }
        return $this;
    }
    /**
     * Get ComercialInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComercialInvoice()
    {
        return isset($this->ComercialInvoice) ? $this->ComercialInvoice : null;
    }
    /**
     * Set ComercialInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comercialInvoice
     * @return \StructType\CustomsData
     */
    public function setComercialInvoice($comercialInvoice = null)
    {
        // validation for constraint: string
        if (!is_null($comercialInvoice) && !is_string($comercialInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comercialInvoice, true), gettype($comercialInvoice)), __LINE__);
        }
        if (is_null($comercialInvoice) || (is_array($comercialInvoice) && empty($comercialInvoice))) {
            unset($this->ComercialInvoice);
        } else {
            $this->ComercialInvoice = $comercialInvoice;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \StructType\CustomsData
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get CustomsItemsData value
     * @return \ArrayType\ArrayOfCustomsItemsData|null
     */
    public function getCustomsItemsData()
    {
        return $this->CustomsItemsData;
    }
    /**
     * Set CustomsItemsData value
     * @param \ArrayType\ArrayOfCustomsItemsData $customsItemsData
     * @return \StructType\CustomsData
     */
    public function setCustomsItemsData(\ArrayType\ArrayOfCustomsItemsData $customsItemsData = null)
    {
        $this->CustomsItemsData = $customsItemsData;
        return $this;
    }
    /**
     * Get CustomsTotalItems value
     * @return string|null
     */
    public function getCustomsTotalItems()
    {
        return $this->CustomsTotalItems;
    }
    /**
     * Set CustomsTotalItems value
     * @param string $customsTotalItems
     * @return \StructType\CustomsData
     */
    public function setCustomsTotalItems($customsTotalItems = null)
    {
        // validation for constraint: string
        if (!is_null($customsTotalItems) && !is_string($customsTotalItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTotalItems, true), gettype($customsTotalItems)), __LINE__);
        }
        $this->CustomsTotalItems = $customsTotalItems;
        return $this;
    }
    /**
     * Get CustomsTotalValue value
     * @return string|null
     */
    public function getCustomsTotalValue()
    {
        return $this->CustomsTotalValue;
    }
    /**
     * Set CustomsTotalValue value
     * @param string $customsTotalValue
     * @return \StructType\CustomsData
     */
    public function setCustomsTotalValue($customsTotalValue = null)
    {
        // validation for constraint: string
        if (!is_null($customsTotalValue) && !is_string($customsTotalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTotalValue, true), gettype($customsTotalValue)), __LINE__);
        }
        $this->CustomsTotalValue = $customsTotalValue;
        return $this;
    }
    /**
     * Get CustomsTotalWeight value
     * @return string|null
     */
    public function getCustomsTotalWeight()
    {
        return $this->CustomsTotalWeight;
    }
    /**
     * Set CustomsTotalWeight value
     * @param string $customsTotalWeight
     * @return \StructType\CustomsData
     */
    public function setCustomsTotalWeight($customsTotalWeight = null)
    {
        // validation for constraint: string
        if (!is_null($customsTotalWeight) && !is_string($customsTotalWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsTotalWeight, true), gettype($customsTotalWeight)), __LINE__);
        }
        $this->CustomsTotalWeight = $customsTotalWeight;
        return $this;
    }
    /**
     * Get ExportLicence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExportLicence()
    {
        return isset($this->ExportLicence) ? $this->ExportLicence : null;
    }
    /**
     * Set ExportLicence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exportLicence
     * @return \StructType\CustomsData
     */
    public function setExportLicence($exportLicence = null)
    {
        // validation for constraint: string
        if (!is_null($exportLicence) && !is_string($exportLicence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLicence, true), gettype($exportLicence)), __LINE__);
        }
        if (is_null($exportLicence) || (is_array($exportLicence) && empty($exportLicence))) {
            unset($this->ExportLicence);
        } else {
            $this->ExportLicence = $exportLicence;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $height
     * @return \StructType\CustomsData
     */
    public function setHeight($height = null)
    {
        // validation for constraint: string
        if (!is_null($height) && !is_string($height)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get InsurancePremium value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsurancePremium()
    {
        return isset($this->InsurancePremium) ? $this->InsurancePremium : null;
    }
    /**
     * Set InsurancePremium value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insurancePremium
     * @return \StructType\CustomsData
     */
    public function setInsurancePremium($insurancePremium = null)
    {
        // validation for constraint: string
        if (!is_null($insurancePremium) && !is_string($insurancePremium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insurancePremium, true), gettype($insurancePremium)), __LINE__);
        }
        if (is_null($insurancePremium) || (is_array($insurancePremium) && empty($insurancePremium))) {
            unset($this->InsurancePremium);
        } else {
            $this->InsurancePremium = $insurancePremium;
        }
        return $this;
    }
    /**
     * Get InsuranceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsuranceValue()
    {
        return isset($this->InsuranceValue) ? $this->InsuranceValue : null;
    }
    /**
     * Set InsuranceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $insuranceValue
     * @return \StructType\CustomsData
     */
    public function setInsuranceValue($insuranceValue = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceValue) && !is_string($insuranceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceValue, true), gettype($insuranceValue)), __LINE__);
        }
        if (is_null($insuranceValue) || (is_array($insuranceValue) && empty($insuranceValue))) {
            unset($this->InsuranceValue);
        } else {
            $this->InsuranceValue = $insuranceValue;
        }
        return $this;
    }
    /**
     * Get Length value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLength()
    {
        return isset($this->Length) ? $this->Length : null;
    }
    /**
     * Set Length value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $length
     * @return \StructType\CustomsData
     */
    public function setLength($length = null)
    {
        // validation for constraint: string
        if (!is_null($length) && !is_string($length)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        if (is_null($length) || (is_array($length) && empty($length))) {
            unset($this->Length);
        } else {
            $this->Length = $length;
        }
        return $this;
    }
    /**
     * Get NonDeliveryCase value
     * @return string|null
     */
    public function getNonDeliveryCase()
    {
        return $this->NonDeliveryCase;
    }
    /**
     * Set NonDeliveryCase value
     * @uses \EnumType\NonDeliveryCaseValues::valueIsValid()
     * @uses \EnumType\NonDeliveryCaseValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nonDeliveryCase
     * @return \StructType\CustomsData
     */
    public function setNonDeliveryCase($nonDeliveryCase = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NonDeliveryCaseValues::valueIsValid($nonDeliveryCase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NonDeliveryCaseValues', is_array($nonDeliveryCase) ? implode(', ', $nonDeliveryCase) : var_export($nonDeliveryCase, true), implode(', ', \EnumType\NonDeliveryCaseValues::getValidValues())), __LINE__);
        }
        $this->NonDeliveryCase = $nonDeliveryCase;
        return $this;
    }
    /**
     * Get OriginCertificateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginCertificateNumber()
    {
        return isset($this->OriginCertificateNumber) ? $this->OriginCertificateNumber : null;
    }
    /**
     * Set OriginCertificateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originCertificateNumber
     * @return \StructType\CustomsData
     */
    public function setOriginCertificateNumber($originCertificateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($originCertificateNumber) && !is_string($originCertificateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCertificateNumber, true), gettype($originCertificateNumber)), __LINE__);
        }
        if (is_null($originCertificateNumber) || (is_array($originCertificateNumber) && empty($originCertificateNumber))) {
            unset($this->OriginCertificateNumber);
        } else {
            $this->OriginCertificateNumber = $originCertificateNumber;
        }
        return $this;
    }
    /**
     * Get ReceiverTIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverTIN()
    {
        return isset($this->ReceiverTIN) ? $this->ReceiverTIN : null;
    }
    /**
     * Set ReceiverTIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverTIN
     * @return \StructType\CustomsData
     */
    public function setReceiverTIN($receiverTIN = null)
    {
        // validation for constraint: string
        if (!is_null($receiverTIN) && !is_string($receiverTIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverTIN, true), gettype($receiverTIN)), __LINE__);
        }
        if (is_null($receiverTIN) || (is_array($receiverTIN) && empty($receiverTIN))) {
            unset($this->ReceiverTIN);
        } else {
            $this->ReceiverTIN = $receiverTIN;
        }
        return $this;
    }
    /**
     * Get SachetDocumentation value
     * @return bool|null
     */
    public function getSachetDocumentation()
    {
        return $this->SachetDocumentation;
    }
    /**
     * Set SachetDocumentation value
     * @param bool $sachetDocumentation
     * @return \StructType\CustomsData
     */
    public function setSachetDocumentation($sachetDocumentation = null)
    {
        // validation for constraint: boolean
        if (!is_null($sachetDocumentation) && !is_bool($sachetDocumentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sachetDocumentation, true), gettype($sachetDocumentation)), __LINE__);
        }
        $this->SachetDocumentation = $sachetDocumentation;
        return $this;
    }
    /**
     * Get SenderEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderEmail()
    {
        return isset($this->SenderEmail) ? $this->SenderEmail : null;
    }
    /**
     * Set SenderEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderEmail
     * @return \StructType\CustomsData
     */
    public function setSenderEmail($senderEmail = null)
    {
        // validation for constraint: string
        if (!is_null($senderEmail) && !is_string($senderEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderEmail, true), gettype($senderEmail)), __LINE__);
        }
        if (is_null($senderEmail) || (is_array($senderEmail) && empty($senderEmail))) {
            unset($this->SenderEmail);
        } else {
            $this->SenderEmail = $senderEmail;
        }
        return $this;
    }
    /**
     * Get ServiceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceValue()
    {
        return isset($this->ServiceValue) ? $this->ServiceValue : null;
    }
    /**
     * Set ServiceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceValue
     * @return \StructType\CustomsData
     */
    public function setServiceValue($serviceValue = null)
    {
        // validation for constraint: string
        if (!is_null($serviceValue) && !is_string($serviceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceValue, true), gettype($serviceValue)), __LINE__);
        }
        if (is_null($serviceValue) || (is_array($serviceValue) && empty($serviceValue))) {
            unset($this->ServiceValue);
        } else {
            $this->ServiceValue = $serviceValue;
        }
        return $this;
    }
    /**
     * Get VATExportDeclaration value
     * @return bool|null
     */
    public function getVATExportDeclaration()
    {
        return $this->VATExportDeclaration;
    }
    /**
     * Set VATExportDeclaration value
     * @param bool $vATExportDeclaration
     * @return \StructType\CustomsData
     */
    public function setVATExportDeclaration($vATExportDeclaration = null)
    {
        // validation for constraint: boolean
        if (!is_null($vATExportDeclaration) && !is_bool($vATExportDeclaration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vATExportDeclaration, true), gettype($vATExportDeclaration)), __LINE__);
        }
        $this->VATExportDeclaration = $vATExportDeclaration;
        return $this;
    }
    /**
     * Get VATRate value
     * @return bool|null
     */
    public function getVATRate()
    {
        return $this->VATRate;
    }
    /**
     * Set VATRate value
     * @param bool $vATRate
     * @return \StructType\CustomsData
     */
    public function setVATRate($vATRate = null)
    {
        // validation for constraint: boolean
        if (!is_null($vATRate) && !is_bool($vATRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vATRate, true), gettype($vATRate)), __LINE__);
        }
        $this->VATRate = $vATRate;
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $width
     * @return \StructType\CustomsData
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomsData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
