<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialService StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SpecialService
 * @subpackage Structs
 */
class SpecialService extends AbstractStructBase
{
    /**
     * The CertainDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CertainDate;
    /**
     * The DDA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DDA
     */
    public $DDA;
    /**
     * The DeliveryPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeliveryPointData
     */
    public $DeliveryPoint;
    /**
     * The MultipleHomeDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MultipleHomeDeliveryData
     */
    public $MultipleHomeDelivery;
    /**
     * The ReturnAuthorization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReturnAuthorizationData
     */
    public $ReturnAuthorization;
    /**
     * The SpecialServiceType
     * @var string
     */
    public $SpecialServiceType;
    /**
     * The TimeWindow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TimeWindowData
     */
    public $TimeWindow;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * Constructor method for SpecialService
     * @uses SpecialService::setCertainDate()
     * @uses SpecialService::setDDA()
     * @uses SpecialService::setDeliveryPoint()
     * @uses SpecialService::setMultipleHomeDelivery()
     * @uses SpecialService::setReturnAuthorization()
     * @uses SpecialService::setSpecialServiceType()
     * @uses SpecialService::setTimeWindow()
     * @uses SpecialService::setValue()
     * @param string $certainDate
     * @param \StructType\DDA $dDA
     * @param \StructType\DeliveryPointData $deliveryPoint
     * @param \StructType\MultipleHomeDeliveryData $multipleHomeDelivery
     * @param \StructType\ReturnAuthorizationData $returnAuthorization
     * @param string $specialServiceType
     * @param \StructType\TimeWindowData $timeWindow
     * @param float $value
     */
    public function __construct($certainDate = null, \StructType\DDA $dDA = null, \StructType\DeliveryPointData $deliveryPoint = null, \StructType\MultipleHomeDeliveryData $multipleHomeDelivery = null, \StructType\ReturnAuthorizationData $returnAuthorization = null, $specialServiceType = null, \StructType\TimeWindowData $timeWindow = null, $value = null)
    {
        $this
            ->setCertainDate($certainDate)
            ->setDDA($dDA)
            ->setDeliveryPoint($deliveryPoint)
            ->setMultipleHomeDelivery($multipleHomeDelivery)
            ->setReturnAuthorization($returnAuthorization)
            ->setSpecialServiceType($specialServiceType)
            ->setTimeWindow($timeWindow)
            ->setValue($value);
    }
    /**
     * Get CertainDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertainDate()
    {
        return isset($this->CertainDate) ? $this->CertainDate : null;
    }
    /**
     * Set CertainDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $certainDate
     * @return \StructType\SpecialService
     */
    public function setCertainDate($certainDate = null)
    {
        // validation for constraint: string
        if (!is_null($certainDate) && !is_string($certainDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certainDate, true), gettype($certainDate)), __LINE__);
        }
        if (is_null($certainDate) || (is_array($certainDate) && empty($certainDate))) {
            unset($this->CertainDate);
        } else {
            $this->CertainDate = $certainDate;
        }
        return $this;
    }
    /**
     * Get DDA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DDA|null
     */
    public function getDDA()
    {
        return isset($this->DDA) ? $this->DDA : null;
    }
    /**
     * Set DDA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DDA $dDA
     * @return \StructType\SpecialService
     */
    public function setDDA(\StructType\DDA $dDA = null)
    {
        if (is_null($dDA) || (is_array($dDA) && empty($dDA))) {
            unset($this->DDA);
        } else {
            $this->DDA = $dDA;
        }
        return $this;
    }
    /**
     * Get DeliveryPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeliveryPointData|null
     */
    public function getDeliveryPoint()
    {
        return isset($this->DeliveryPoint) ? $this->DeliveryPoint : null;
    }
    /**
     * Set DeliveryPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DeliveryPointData $deliveryPoint
     * @return \StructType\SpecialService
     */
    public function setDeliveryPoint(\StructType\DeliveryPointData $deliveryPoint = null)
    {
        if (is_null($deliveryPoint) || (is_array($deliveryPoint) && empty($deliveryPoint))) {
            unset($this->DeliveryPoint);
        } else {
            $this->DeliveryPoint = $deliveryPoint;
        }
        return $this;
    }
    /**
     * Get MultipleHomeDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MultipleHomeDeliveryData|null
     */
    public function getMultipleHomeDelivery()
    {
        return isset($this->MultipleHomeDelivery) ? $this->MultipleHomeDelivery : null;
    }
    /**
     * Set MultipleHomeDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MultipleHomeDeliveryData $multipleHomeDelivery
     * @return \StructType\SpecialService
     */
    public function setMultipleHomeDelivery(\StructType\MultipleHomeDeliveryData $multipleHomeDelivery = null)
    {
        if (is_null($multipleHomeDelivery) || (is_array($multipleHomeDelivery) && empty($multipleHomeDelivery))) {
            unset($this->MultipleHomeDelivery);
        } else {
            $this->MultipleHomeDelivery = $multipleHomeDelivery;
        }
        return $this;
    }
    /**
     * Get ReturnAuthorization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReturnAuthorizationData|null
     */
    public function getReturnAuthorization()
    {
        return isset($this->ReturnAuthorization) ? $this->ReturnAuthorization : null;
    }
    /**
     * Set ReturnAuthorization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReturnAuthorizationData $returnAuthorization
     * @return \StructType\SpecialService
     */
    public function setReturnAuthorization(\StructType\ReturnAuthorizationData $returnAuthorization = null)
    {
        if (is_null($returnAuthorization) || (is_array($returnAuthorization) && empty($returnAuthorization))) {
            unset($this->ReturnAuthorization);
        } else {
            $this->ReturnAuthorization = $returnAuthorization;
        }
        return $this;
    }
    /**
     * Get SpecialServiceType value
     * @return string|null
     */
    public function getSpecialServiceType()
    {
        return $this->SpecialServiceType;
    }
    /**
     * Set SpecialServiceType value
     * @uses \EnumType\SpecialServiceTypeValues::valueIsValid()
     * @uses \EnumType\SpecialServiceTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $specialServiceType
     * @return \StructType\SpecialService
     */
    public function setSpecialServiceType($specialServiceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SpecialServiceTypeValues::valueIsValid($specialServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SpecialServiceTypeValues', is_array($specialServiceType) ? implode(', ', $specialServiceType) : var_export($specialServiceType, true), implode(', ', \EnumType\SpecialServiceTypeValues::getValidValues())), __LINE__);
        }
        $this->SpecialServiceType = $specialServiceType;
        return $this;
    }
    /**
     * Get TimeWindow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TimeWindowData|null
     */
    public function getTimeWindow()
    {
        return isset($this->TimeWindow) ? $this->TimeWindow : null;
    }
    /**
     * Set TimeWindow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TimeWindowData $timeWindow
     * @return \StructType\SpecialService
     */
    public function setTimeWindow(\StructType\TimeWindowData $timeWindow = null)
    {
        if (is_null($timeWindow) || (is_array($timeWindow) && empty($timeWindow))) {
            unset($this->TimeWindow);
        } else {
            $this->TimeWindow = $timeWindow;
        }
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\SpecialService
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
