<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryPointData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryPointData
 * @subpackage Structs
 */
class DeliveryPointData extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for DeliveryPointData
     * @uses DeliveryPointData::setCode()
     * @uses DeliveryPointData::setName()
     * @uses DeliveryPointData::setType()
     * @param string $code
     * @param string $name
     * @param string $type
     */
    public function __construct($code = null, $name = null, $type = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setType($type);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\DeliveryPointData
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\DeliveryPointData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\DeliveryPointTypeValues::valueIsValid()
     * @uses \EnumType\DeliveryPointTypeValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DeliveryPointData
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryPointTypeValues::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveryPointTypeValues', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\DeliveryPointTypeValues::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryPointData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
