<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnAuthorizationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReturnAuthorizationData
 * @subpackage Structs
 */
class ReturnAuthorizationData extends AbstractStructBase
{
    /**
     * The AddressData
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\AddressData
     */
    public $AddressData;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * The ValidationDate
     * @var string
     */
    public $ValidationDate;
    /**
     * Constructor method for ReturnAuthorizationData
     * @uses ReturnAuthorizationData::setAddressData()
     * @uses ReturnAuthorizationData::setProductCode()
     * @uses ReturnAuthorizationData::setValidationDate()
     * @param \StructType\AddressData $addressData
     * @param string $productCode
     * @param string $validationDate
     */
    public function __construct(\StructType\AddressData $addressData = null, $productCode = null, $validationDate = null)
    {
        $this
            ->setAddressData($addressData)
            ->setProductCode($productCode)
            ->setValidationDate($validationDate);
    }
    /**
     * Get AddressData value
     * @return \StructType\AddressData|null
     */
    public function getAddressData()
    {
        return $this->AddressData;
    }
    /**
     * Set AddressData value
     * @param \StructType\AddressData $addressData
     * @return \StructType\ReturnAuthorizationData
     */
    public function setAddressData(\StructType\AddressData $addressData = null)
    {
        $this->AddressData = $addressData;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param string $productCode
     * @return \StructType\ReturnAuthorizationData
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ValidationDate value
     * @return string|null
     */
    public function getValidationDate()
    {
        return $this->ValidationDate;
    }
    /**
     * Set ValidationDate value
     * @param string $validationDate
     * @return \StructType\ReturnAuthorizationData
     */
    public function setValidationDate($validationDate = null)
    {
        // validation for constraint: string
        if (!is_null($validationDate) && !is_string($validationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationDate, true), gettype($validationDate)), __LINE__);
        }
        $this->ValidationDate = $validationDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReturnAuthorizationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
