<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateShipmentOutput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateShipmentOutput
 * @subpackage Structs
 */
class CreateShipmentOutput extends AbstractStructBase
{
    /**
     * The ErrorsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfErrorData
     */
    public $ErrorsList;
    /**
     * The ShipmentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfShipmentDataOutput
     */
    public $ShipmentData;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for CreateShipmentOutput
     * @uses CreateShipmentOutput::setErrorsList()
     * @uses CreateShipmentOutput::setShipmentData()
     * @uses CreateShipmentOutput::setStatus()
     * @param \ArrayType\ArrayOfErrorData $errorsList
     * @param \ArrayType\ArrayOfShipmentDataOutput $shipmentData
     * @param string $status
     */
    public function __construct(\ArrayType\ArrayOfErrorData $errorsList = null, \ArrayType\ArrayOfShipmentDataOutput $shipmentData = null, $status = null)
    {
        $this
            ->setErrorsList($errorsList)
            ->setShipmentData($shipmentData)
            ->setStatus($status);
    }
    /**
     * Get ErrorsList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfErrorData|null
     */
    public function getErrorsList()
    {
        return isset($this->ErrorsList) ? $this->ErrorsList : null;
    }
    /**
     * Set ErrorsList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfErrorData $errorsList
     * @return \StructType\CreateShipmentOutput
     */
    public function setErrorsList(\ArrayType\ArrayOfErrorData $errorsList = null)
    {
        if (is_null($errorsList) || (is_array($errorsList) && empty($errorsList))) {
            unset($this->ErrorsList);
        } else {
            $this->ErrorsList = $errorsList;
        }
        return $this;
    }
    /**
     * Get ShipmentData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfShipmentDataOutput|null
     */
    public function getShipmentData()
    {
        return isset($this->ShipmentData) ? $this->ShipmentData : null;
    }
    /**
     * Set ShipmentData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfShipmentDataOutput $shipmentData
     * @return \StructType\CreateShipmentOutput
     */
    public function setShipmentData(\ArrayType\ArrayOfShipmentDataOutput $shipmentData = null)
    {
        if (is_null($shipmentData) || (is_array($shipmentData) && empty($shipmentData))) {
            unset($this->ShipmentData);
        } else {
            $this->ShipmentData = $shipmentData;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\StatusValues::valueIsValid()
     * @uses \EnumType\StatusValues::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\CreateShipmentOutput
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusValues::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusValues', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\StatusValues::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateShipmentOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
