<?php

namespace EnumType;

/**
 * This class stands for ExportTypeValues EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExportTypeValues
 * @subpackage Enumerations
 */
class ExportTypeValues
{
    /**
     * Constant for value 'Permanent'
     * @return string 'Permanent'
     */
    const VALUE_PERMANENT = 'Permanent';
    /**
     * Constant for value 'TemporaryPassiveImprovement'
     * @return string 'TemporaryPassiveImprovement'
     */
    const VALUE_TEMPORARY_PASSIVE_IMPROVEMENT = 'TemporaryPassiveImprovement';
    /**
     * Constant for value 'TemporaryExhibition'
     * @return string 'TemporaryExhibition'
     */
    const VALUE_TEMPORARY_EXHIBITION = 'TemporaryExhibition';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PERMANENT
     * @uses self::VALUE_TEMPORARY_PASSIVE_IMPROVEMENT
     * @uses self::VALUE_TEMPORARY_EXHIBITION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PERMANENT,
            self::VALUE_TEMPORARY_PASSIVE_IMPROVEMENT,
            self::VALUE_TEMPORARY_EXHIBITION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
