<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'DDA' => '\\StructType\\DDA',
            'DeliveryPointData' => '\\StructType\\DeliveryPointData',
            'MultipleHomeDeliveryData' => '\\StructType\\MultipleHomeDeliveryData',
            'ReturnAuthorizationData' => '\\StructType\\ReturnAuthorizationData',
            'TimeWindowData' => '\\StructType\\TimeWindowData',
            'DeliveryNote' => '\\StructType\\DeliveryNote',
            'ArrayOfShipmentCTT' => '\\ArrayType\\ArrayOfShipmentCTT',
            'ShipmentCTT' => '\\StructType\\ShipmentCTT',
            'DeliveryAggregationInf' => '\\StructType\\DeliveryAggregationInf',
            'ArrayOfPIPAuthorizationData' => '\\ArrayType\\ArrayOfPIPAuthorizationData',
            'PIPAuthorizationData' => '\\StructType\\PIPAuthorizationData',
            'AddressData' => '\\StructType\\AddressData',
            'ShipmentData' => '\\StructType\\ShipmentData',
            'CargoData' => '\\StructType\\CargoData',
            'CustomsData' => '\\StructType\\CustomsData',
            'ArrayOfCustomsItemsData' => '\\ArrayType\\ArrayOfCustomsItemsData',
            'CustomsItemsData' => '\\StructType\\CustomsItemsData',
            'ArrayOfSpecialService' => '\\ArrayType\\ArrayOfSpecialService',
            'SpecialService' => '\\StructType\\SpecialService',
            'CompleteShipmentInput' => '\\StructType\\CompleteShipmentInput',
            'CompleteShipmentOutput' => '\\StructType\\CompleteShipmentOutput',
            'ArrayOfErrorData' => '\\ArrayType\\ArrayOfErrorData',
            'ErrorData' => '\\StructType\\ErrorData',
            'ArrayOfShipmentDataOutput' => '\\ArrayType\\ArrayOfShipmentDataOutput',
            'ShipmentDataOutput' => '\\StructType\\ShipmentDataOutput',
            'ArrayOfDocumentData' => '\\ArrayType\\ArrayOfDocumentData',
            'DocumentData' => '\\StructType\\DocumentData',
            'ArrayOfLabelData' => '\\ArrayType\\ArrayOfLabelData',
            'LabelData' => '\\StructType\\LabelData',
            'CreateShipmentInput' => '\\StructType\\CreateShipmentInput',
            'CreateShipmentOutput' => '\\StructType\\CreateShipmentOutput',
            'CloseShipmentInput' => '\\StructType\\CloseShipmentInput',
            'ArrayOfShipment2Close' => '\\ArrayType\\ArrayOfShipment2Close',
            'Shipment2Close' => '\\StructType\\Shipment2Close',
            'CloseShipmentOutput' => '\\StructType\\CloseShipmentOutput',
            'CompleteShipment' => '\\StructType\\CompleteShipment',
            'CompleteShipmentResponse' => '\\StructType\\CompleteShipmentResponse',
            'CreateShipment' => '\\StructType\\CreateShipment',
            'CreateShipmentResponse' => '\\StructType\\CreateShipmentResponse',
            'CreateShipmentWithoutPrint' => '\\StructType\\CreateShipmentWithoutPrint',
            'CreateShipmentWithoutPrintResponse' => '\\StructType\\CreateShipmentWithoutPrintResponse',
            'CloseShipment' => '\\StructType\\CloseShipment',
            'CloseShipmentResponse' => '\\StructType\\CloseShipmentResponse',
        );
    }
}
