<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShipmentDataOutput ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfShipmentDataOutput
 * @subpackage Arrays
 */
class ArrayOfShipmentDataOutput extends AbstractStructArrayBase
{
    /**
     * The ShipmentDataOutput
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShipmentDataOutput[]
     */
    public $ShipmentDataOutput;
    /**
     * Constructor method for ArrayOfShipmentDataOutput
     * @uses ArrayOfShipmentDataOutput::setShipmentDataOutput()
     * @param \StructType\ShipmentDataOutput[] $shipmentDataOutput
     */
    public function __construct(array $shipmentDataOutput = array())
    {
        $this
            ->setShipmentDataOutput($shipmentDataOutput);
    }
    /**
     * Get ShipmentDataOutput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShipmentDataOutput[]|null
     */
    public function getShipmentDataOutput()
    {
        return isset($this->ShipmentDataOutput) ? $this->ShipmentDataOutput : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentDataOutput method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDataOutput method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDataOutputForArrayConstraintsFromSetShipmentDataOutput(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShipmentDataOutputShipmentDataOutputItem) {
            // validation for constraint: itemType
            if (!$arrayOfShipmentDataOutputShipmentDataOutputItem instanceof \StructType\ShipmentDataOutput) {
                $invalidValues[] = is_object($arrayOfShipmentDataOutputShipmentDataOutputItem) ? get_class($arrayOfShipmentDataOutputShipmentDataOutputItem) : sprintf('%s(%s)', gettype($arrayOfShipmentDataOutputShipmentDataOutputItem), var_export($arrayOfShipmentDataOutputShipmentDataOutputItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentDataOutput property can only contain items of type \StructType\ShipmentDataOutput, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentDataOutput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDataOutput[] $shipmentDataOutput
     * @return \ArrayType\ArrayOfShipmentDataOutput
     */
    public function setShipmentDataOutput(array $shipmentDataOutput = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDataOutputArrayErrorMessage = self::validateShipmentDataOutputForArrayConstraintsFromSetShipmentDataOutput($shipmentDataOutput))) {
            throw new \InvalidArgumentException($shipmentDataOutputArrayErrorMessage, __LINE__);
        }
        if (is_null($shipmentDataOutput) || (is_array($shipmentDataOutput) && empty($shipmentDataOutput))) {
            unset($this->ShipmentDataOutput);
        } else {
            $this->ShipmentDataOutput = $shipmentDataOutput;
        }
        return $this;
    }
    /**
     * Add item to ShipmentDataOutput value
     * @throws \InvalidArgumentException
     * @param \StructType\ShipmentDataOutput $item
     * @return \ArrayType\ArrayOfShipmentDataOutput
     */
    public function addToShipmentDataOutput(\StructType\ShipmentDataOutput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShipmentDataOutput) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDataOutput property can only contain items of type \StructType\ShipmentDataOutput, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentDataOutput[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShipmentDataOutput|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShipmentDataOutput|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShipmentDataOutput|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShipmentDataOutput|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShipmentDataOutput|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShipmentDataOutput
     */
    public function getAttributeName()
    {
        return 'ShipmentDataOutput';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShipmentDataOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
