<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Pepitelabs\PWS\ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \Pepitelabs\PWS\ReturnsManagementService\Create($options);
$create->setSoapHeaderRequestContext(new \Pepitelabs\PWS\ReturnsManagementService\RequestContext());
/**
 * Sample call for CreateReturnsManagementShipment operation/method
 */
if ($create->CreateReturnsManagementShipment(new \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentRequestContainer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \Pepitelabs\PWS\ReturnsManagementService\Validate($options);
$validate->setSoapHeaderRequestContext(new \Pepitelabs\PWS\ReturnsManagementService\RequestContext());
/**
 * Sample call for ValidateReturnsManagementShipment operation/method
 */
if ($validate->ValidateReturnsManagementShipment(new \Pepitelabs\PWS\ReturnsManagementService\ValidateReturnsManagementShipmentRequestContainer()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
