<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherInformation ReturnsManagementService
 * Meta information extracted from the WSDL
 * - documentation: OtherInformation
 * - nillable: true
 * - type: tns:OtherInformation
 * @subpackage Structs
 */
class OtherInformation extends AbstractStructBase
{
    /**
     * The CostCentre
     * Meta information extracted from the WSDL
     * - documentation: CostCentre - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CostCentre;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - documentation: SpecialInstructions - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialInstructions;
    /**
     * Constructor method for OtherInformation
     * @uses OtherInformation::setCostCentre()
     * @uses OtherInformation::setSpecialInstructions()
     * @param string $costCentre
     * @param string $specialInstructions
     */
    public function __construct($costCentre = null, $specialInstructions = null)
    {
        $this
            ->setCostCentre($costCentre)
            ->setSpecialInstructions($specialInstructions);
    }
    /**
     * Get CostCentre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCostCentre()
    {
        return isset($this->CostCentre) ? $this->CostCentre : null;
    }
    /**
     * Set CostCentre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $costCentre
     * @return \Pepitelabs\PWS\ReturnsManagementService\OtherInformation
     */
    public function setCostCentre($costCentre = null)
    {
        // validation for constraint: string
        if (!is_null($costCentre) && !is_string($costCentre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCentre, true), gettype($costCentre)), __LINE__);
        }
        if (is_null($costCentre) || (is_array($costCentre) && empty($costCentre))) {
            unset($this->CostCentre);
        } else {
            $this->CostCentre = $costCentre;
        }
        return $this;
    }
    /**
     * Get SpecialInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialInstructions()
    {
        return isset($this->SpecialInstructions) ? $this->SpecialInstructions : null;
    }
    /**
     * Set SpecialInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialInstructions
     * @return \Pepitelabs\PWS\ReturnsManagementService\OtherInformation
     */
    public function setSpecialInstructions($specialInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions) && !is_string($specialInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions, true), gettype($specialInstructions)), __LINE__);
        }
        if (is_null($specialInstructions) || (is_array($specialInstructions) && empty($specialInstructions))) {
            unset($this->SpecialInstructions);
        } else {
            $this->SpecialInstructions = $specialInstructions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ReturnsManagementService\OtherInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
