<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateReturnsManagementShipmentRequestContainer
 * ReturnsManagementService
 * Meta information extracted from the WSDL
 * - documentation: CreateReturnsManagementShipmentRequestContainer
 * - nillable: true
 * - type: tns:CreateReturnsManagementShipmentRequestContainer
 * @subpackage Structs
 */
class CreateReturnsManagementShipmentRequestContainer extends RequestContainer
{
    /**
     * The RMA
     * Meta information extracted from the WSDL
     * - documentation: RMA - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RMA;
    /**
     * The ReturnsManagementShipment
     * Meta information extracted from the WSDL
     * - documentation: Shipment - ReturnsManagementShipment
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public $ReturnsManagementShipment;
    /**
     * The PrinterType
     * Meta information extracted from the WSDL
     * - documentation: PrinterType - PrinterType
     * - nillable: true
     * @var string
     */
    public $PrinterType;
    /**
     * Constructor method for CreateReturnsManagementShipmentRequestContainer
     * @uses CreateReturnsManagementShipmentRequestContainer::setRMA()
     * @uses CreateReturnsManagementShipmentRequestContainer::setReturnsManagementShipment()
     * @uses CreateReturnsManagementShipmentRequestContainer::setPrinterType()
     * @param string $rMA
     * @param \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment $returnsManagementShipment
     * @param string $printerType
     */
    public function __construct($rMA = null, \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment $returnsManagementShipment = null, $printerType = null)
    {
        $this
            ->setRMA($rMA)
            ->setReturnsManagementShipment($returnsManagementShipment)
            ->setPrinterType($printerType);
    }
    /**
     * Get RMA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRMA()
    {
        return isset($this->RMA) ? $this->RMA : null;
    }
    /**
     * Set RMA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rMA
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentRequestContainer
     */
    public function setRMA($rMA = null)
    {
        // validation for constraint: string
        if (!is_null($rMA) && !is_string($rMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rMA, true), gettype($rMA)), __LINE__);
        }
        if (is_null($rMA) || (is_array($rMA) && empty($rMA))) {
            unset($this->RMA);
        } else {
            $this->RMA = $rMA;
        }
        return $this;
    }
    /**
     * Get ReturnsManagementShipment value
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment|null
     */
    public function getReturnsManagementShipment()
    {
        return $this->ReturnsManagementShipment;
    }
    /**
     * Set ReturnsManagementShipment value
     * @param \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment $returnsManagementShipment
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentRequestContainer
     */
    public function setReturnsManagementShipment(\Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment $returnsManagementShipment = null)
    {
        $this->ReturnsManagementShipment = $returnsManagementShipment;
        return $this;
    }
    /**
     * Get PrinterType value
     * @return string|null
     */
    public function getPrinterType()
    {
        return $this->PrinterType;
    }
    /**
     * Set PrinterType value
     * @uses \Pepitelabs\PWS\ReturnsManagementService\PrinterType::valueIsValid()
     * @uses \Pepitelabs\PWS\ReturnsManagementService\PrinterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printerType
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentRequestContainer
     */
    public function setPrinterType($printerType = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\ReturnsManagementService\PrinterType::valueIsValid($printerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\ReturnsManagementService\PrinterType', is_array($printerType) ? implode(', ', $printerType) : var_export($printerType, true), implode(', ', \Pepitelabs\PWS\ReturnsManagementService\PrinterType::getValidValues())), __LINE__);
        }
        $this->PrinterType = $printerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentRequestContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
