<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalWeight ReturnsManagementService
 * Meta information extracted from the WSDL
 * - documentation: TotalWeight
 * - nillable: true
 * - type: tns:TotalWeight
 * @subpackage Structs
 */
class TotalWeight extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - documentation: Value - decimal
     * - nillable: true
     * @var int
     */
    public $Value;
    /**
     * The WeightUnit
     * Meta information extracted from the WSDL
     * - documentation: WeightUnit - WeightUnit
     * @var string
     */
    public $WeightUnit;
    /**
     * Constructor method for TotalWeight
     * @uses TotalWeight::setValue()
     * @uses TotalWeight::setWeightUnit()
     * @param int $value
     * @param string $weightUnit
     */
    public function __construct($value = null, $weightUnit = null)
    {
        $this
            ->setValue($value)
            ->setWeightUnit($weightUnit);
    }
    /**
     * Get Value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \Pepitelabs\PWS\ReturnsManagementService\TotalWeight
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get WeightUnit value
     * @return string|null
     */
    public function getWeightUnit()
    {
        return $this->WeightUnit;
    }
    /**
     * Set WeightUnit value
     * @uses \Pepitelabs\PWS\ReturnsManagementService\WeightUnit::valueIsValid()
     * @uses \Pepitelabs\PWS\ReturnsManagementService\WeightUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weightUnit
     * @return \Pepitelabs\PWS\ReturnsManagementService\TotalWeight
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\ReturnsManagementService\WeightUnit::valueIsValid($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\ReturnsManagementService\WeightUnit', is_array($weightUnit) ? implode(', ', $weightUnit) : var_export($weightUnit, true), implode(', ', \Pepitelabs\PWS\ReturnsManagementService\WeightUnit::getValidValues())), __LINE__);
        }
        $this->WeightUnit = $weightUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ReturnsManagementService\TotalWeight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
