<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateReturnsManagementShipmentResponseContainer
 * ReturnsManagementService
 * Meta information extracted from the WSDL
 * - documentation: CreateReturnsManagementShipmentResponseContainer
 * - nillable: true
 * - type: tns:CreateReturnsManagementShipmentResponseContainer
 * @subpackage Structs
 */
class CreateReturnsManagementShipmentResponseContainer extends ResponseContainer
{
    /**
     * The ShipmentPIN
     * Meta information extracted from the WSDL
     * - documentation: ShipmentPIN - PIN
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\PIN
     */
    public $ShipmentPIN;
    /**
     * The PiecePINs
     * Meta information extracted from the WSDL
     * - documentation: PiecePINs - PIN[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPIN
     */
    public $PiecePINs;
    /**
     * The RMA
     * Meta information extracted from the WSDL
     * - documentation: RMA - string
     * - nillable: true
     * @var string
     */
    public $RMA;
    /**
     * Constructor method for CreateReturnsManagementShipmentResponseContainer
     * @uses CreateReturnsManagementShipmentResponseContainer::setShipmentPIN()
     * @uses CreateReturnsManagementShipmentResponseContainer::setPiecePINs()
     * @uses CreateReturnsManagementShipmentResponseContainer::setRMA()
     * @param \Pepitelabs\PWS\ReturnsManagementService\PIN $shipmentPIN
     * @param \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPIN $piecePINs
     * @param string $rMA
     */
    public function __construct(\Pepitelabs\PWS\ReturnsManagementService\PIN $shipmentPIN = null, \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPIN $piecePINs = null, $rMA = null)
    {
        $this
            ->setShipmentPIN($shipmentPIN)
            ->setPiecePINs($piecePINs)
            ->setRMA($rMA);
    }
    /**
     * Get ShipmentPIN value
     * @return \Pepitelabs\PWS\ReturnsManagementService\PIN|null
     */
    public function getShipmentPIN()
    {
        return $this->ShipmentPIN;
    }
    /**
     * Set ShipmentPIN value
     * @param \Pepitelabs\PWS\ReturnsManagementService\PIN $shipmentPIN
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentResponseContainer
     */
    public function setShipmentPIN(\Pepitelabs\PWS\ReturnsManagementService\PIN $shipmentPIN = null)
    {
        $this->ShipmentPIN = $shipmentPIN;
        return $this;
    }
    /**
     * Get PiecePINs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPIN|null
     */
    public function getPiecePINs()
    {
        return isset($this->PiecePINs) ? $this->PiecePINs : null;
    }
    /**
     * Set PiecePINs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPIN $piecePINs
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentResponseContainer
     */
    public function setPiecePINs(\Pepitelabs\PWS\ReturnsManagementService\ArrayOfPIN $piecePINs = null)
    {
        if (is_null($piecePINs) || (is_array($piecePINs) && empty($piecePINs))) {
            unset($this->PiecePINs);
        } else {
            $this->PiecePINs = $piecePINs;
        }
        return $this;
    }
    /**
     * Get RMA value
     * @return string|null
     */
    public function getRMA()
    {
        return $this->RMA;
    }
    /**
     * Set RMA value
     * @param string $rMA
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentResponseContainer
     */
    public function setRMA($rMA = null)
    {
        // validation for constraint: string
        if (!is_null($rMA) && !is_string($rMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rMA, true), gettype($rMA)), __LINE__);
        }
        $this->RMA = $rMA;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentResponseContainer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
