<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ReturnsManagementService
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\ReturnsManagementService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\ReturnsManagementService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v2', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateReturnsManagementShipment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v2
     * - SOAPHeaderTypes: \Pepitelabs\PWS\ReturnsManagementService\RequestContext
     * - SOAPHeaders: required
     * - documentation: CreateReturnsManagementShipment @param request CreateReturnShipmentRequest @return CreateReturnShipmentResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentRequestContainer $createReturnsManagementShipmentRequest
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentResponseContainer|bool
     */
    public function CreateReturnsManagementShipment(\Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentRequestContainer $createReturnsManagementShipmentRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateReturnsManagementShipment($createReturnsManagementShipmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreateReturnsManagementShipmentResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
