<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnsManagementShipment ReturnsManagementService
 * Meta information extracted from the WSDL
 * - documentation: Shipment
 * - nillable: true
 * - type: tns:ReturnsManagementShipment
 * @subpackage Structs
 */
class ReturnsManagementShipment extends AbstractStructBase
{
    /**
     * The SenderInformation
     * Meta information extracted from the WSDL
     * - documentation: SenderInformation - SenderInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\SenderInformation
     */
    public $SenderInformation;
    /**
     * The ReceiverInformation
     * Meta information extracted from the WSDL
     * - documentation: ReceiverInformation - ReceiverInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\ReceiverInformation
     */
    public $ReceiverInformation;
    /**
     * The PackageInformation
     * Meta information extracted from the WSDL
     * - documentation: PackageInformation - PackageInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public $PackageInformation;
    /**
     * The PaymentInformation
     * Meta information extracted from the WSDL
     * - documentation: PaymentInformation - PaymentInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\PaymentInformation
     */
    public $PaymentInformation;
    /**
     * The PickupInformation
     * Meta information extracted from the WSDL
     * - documentation: PickupInformation - PickupInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\PickupInformation
     */
    public $PickupInformation;
    /**
     * The NotificationInformation
     * Meta information extracted from the WSDL
     * - documentation: NotificationInformation - NotificationInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\NotificationInformation
     */
    public $NotificationInformation;
    /**
     * The TrackingReferenceInformation
     * Meta information extracted from the WSDL
     * - documentation: TrackingReferenceInformation - TrackingReferenceInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\TrackingReferenceInformation
     */
    public $TrackingReferenceInformation;
    /**
     * The OtherInformation
     * Meta information extracted from the WSDL
     * - documentation: OtherInformation - OtherInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\OtherInformation
     */
    public $OtherInformation;
    /**
     * The ProactiveNotification
     * Meta information extracted from the WSDL
     * - documentation: ProactiveNotificationInformation - ProactiveNotificationInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\ProactiveNotification
     */
    public $ProactiveNotification;
    /**
     * Constructor method for ReturnsManagementShipment
     * @uses ReturnsManagementShipment::setSenderInformation()
     * @uses ReturnsManagementShipment::setReceiverInformation()
     * @uses ReturnsManagementShipment::setPackageInformation()
     * @uses ReturnsManagementShipment::setPaymentInformation()
     * @uses ReturnsManagementShipment::setPickupInformation()
     * @uses ReturnsManagementShipment::setNotificationInformation()
     * @uses ReturnsManagementShipment::setTrackingReferenceInformation()
     * @uses ReturnsManagementShipment::setOtherInformation()
     * @uses ReturnsManagementShipment::setProactiveNotification()
     * @param \Pepitelabs\PWS\ReturnsManagementService\SenderInformation $senderInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\ReceiverInformation $receiverInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\PackageInformation $packageInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\PaymentInformation $paymentInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\PickupInformation $pickupInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\NotificationInformation $notificationInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\TrackingReferenceInformation $trackingReferenceInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\OtherInformation $otherInformation
     * @param \Pepitelabs\PWS\ReturnsManagementService\ProactiveNotification $proactiveNotification
     */
    public function __construct(\Pepitelabs\PWS\ReturnsManagementService\SenderInformation $senderInformation = null, \Pepitelabs\PWS\ReturnsManagementService\ReceiverInformation $receiverInformation = null, \Pepitelabs\PWS\ReturnsManagementService\PackageInformation $packageInformation = null, \Pepitelabs\PWS\ReturnsManagementService\PaymentInformation $paymentInformation = null, \Pepitelabs\PWS\ReturnsManagementService\PickupInformation $pickupInformation = null, \Pepitelabs\PWS\ReturnsManagementService\NotificationInformation $notificationInformation = null, \Pepitelabs\PWS\ReturnsManagementService\TrackingReferenceInformation $trackingReferenceInformation = null, \Pepitelabs\PWS\ReturnsManagementService\OtherInformation $otherInformation = null, \Pepitelabs\PWS\ReturnsManagementService\ProactiveNotification $proactiveNotification = null)
    {
        $this
            ->setSenderInformation($senderInformation)
            ->setReceiverInformation($receiverInformation)
            ->setPackageInformation($packageInformation)
            ->setPaymentInformation($paymentInformation)
            ->setPickupInformation($pickupInformation)
            ->setNotificationInformation($notificationInformation)
            ->setTrackingReferenceInformation($trackingReferenceInformation)
            ->setOtherInformation($otherInformation)
            ->setProactiveNotification($proactiveNotification);
    }
    /**
     * Get SenderInformation value
     * @return \Pepitelabs\PWS\ReturnsManagementService\SenderInformation|null
     */
    public function getSenderInformation()
    {
        return $this->SenderInformation;
    }
    /**
     * Set SenderInformation value
     * @param \Pepitelabs\PWS\ReturnsManagementService\SenderInformation $senderInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setSenderInformation(\Pepitelabs\PWS\ReturnsManagementService\SenderInformation $senderInformation = null)
    {
        $this->SenderInformation = $senderInformation;
        return $this;
    }
    /**
     * Get ReceiverInformation value
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReceiverInformation|null
     */
    public function getReceiverInformation()
    {
        return $this->ReceiverInformation;
    }
    /**
     * Set ReceiverInformation value
     * @param \Pepitelabs\PWS\ReturnsManagementService\ReceiverInformation $receiverInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setReceiverInformation(\Pepitelabs\PWS\ReturnsManagementService\ReceiverInformation $receiverInformation = null)
    {
        $this->ReceiverInformation = $receiverInformation;
        return $this;
    }
    /**
     * Get PackageInformation value
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation|null
     */
    public function getPackageInformation()
    {
        return $this->PackageInformation;
    }
    /**
     * Set PackageInformation value
     * @param \Pepitelabs\PWS\ReturnsManagementService\PackageInformation $packageInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setPackageInformation(\Pepitelabs\PWS\ReturnsManagementService\PackageInformation $packageInformation = null)
    {
        $this->PackageInformation = $packageInformation;
        return $this;
    }
    /**
     * Get PaymentInformation value
     * @return \Pepitelabs\PWS\ReturnsManagementService\PaymentInformation|null
     */
    public function getPaymentInformation()
    {
        return $this->PaymentInformation;
    }
    /**
     * Set PaymentInformation value
     * @param \Pepitelabs\PWS\ReturnsManagementService\PaymentInformation $paymentInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setPaymentInformation(\Pepitelabs\PWS\ReturnsManagementService\PaymentInformation $paymentInformation = null)
    {
        $this->PaymentInformation = $paymentInformation;
        return $this;
    }
    /**
     * Get PickupInformation value
     * @return \Pepitelabs\PWS\ReturnsManagementService\PickupInformation|null
     */
    public function getPickupInformation()
    {
        return $this->PickupInformation;
    }
    /**
     * Set PickupInformation value
     * @param \Pepitelabs\PWS\ReturnsManagementService\PickupInformation $pickupInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setPickupInformation(\Pepitelabs\PWS\ReturnsManagementService\PickupInformation $pickupInformation = null)
    {
        $this->PickupInformation = $pickupInformation;
        return $this;
    }
    /**
     * Get NotificationInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ReturnsManagementService\NotificationInformation|null
     */
    public function getNotificationInformation()
    {
        return isset($this->NotificationInformation) ? $this->NotificationInformation : null;
    }
    /**
     * Set NotificationInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ReturnsManagementService\NotificationInformation $notificationInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setNotificationInformation(\Pepitelabs\PWS\ReturnsManagementService\NotificationInformation $notificationInformation = null)
    {
        if (is_null($notificationInformation) || (is_array($notificationInformation) && empty($notificationInformation))) {
            unset($this->NotificationInformation);
        } else {
            $this->NotificationInformation = $notificationInformation;
        }
        return $this;
    }
    /**
     * Get TrackingReferenceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ReturnsManagementService\TrackingReferenceInformation|null
     */
    public function getTrackingReferenceInformation()
    {
        return isset($this->TrackingReferenceInformation) ? $this->TrackingReferenceInformation : null;
    }
    /**
     * Set TrackingReferenceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ReturnsManagementService\TrackingReferenceInformation $trackingReferenceInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setTrackingReferenceInformation(\Pepitelabs\PWS\ReturnsManagementService\TrackingReferenceInformation $trackingReferenceInformation = null)
    {
        if (is_null($trackingReferenceInformation) || (is_array($trackingReferenceInformation) && empty($trackingReferenceInformation))) {
            unset($this->TrackingReferenceInformation);
        } else {
            $this->TrackingReferenceInformation = $trackingReferenceInformation;
        }
        return $this;
    }
    /**
     * Get OtherInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ReturnsManagementService\OtherInformation|null
     */
    public function getOtherInformation()
    {
        return isset($this->OtherInformation) ? $this->OtherInformation : null;
    }
    /**
     * Set OtherInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ReturnsManagementService\OtherInformation $otherInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setOtherInformation(\Pepitelabs\PWS\ReturnsManagementService\OtherInformation $otherInformation = null)
    {
        if (is_null($otherInformation) || (is_array($otherInformation) && empty($otherInformation))) {
            unset($this->OtherInformation);
        } else {
            $this->OtherInformation = $otherInformation;
        }
        return $this;
    }
    /**
     * Get ProactiveNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ReturnsManagementService\ProactiveNotification|null
     */
    public function getProactiveNotification()
    {
        return isset($this->ProactiveNotification) ? $this->ProactiveNotification : null;
    }
    /**
     * Set ProactiveNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ReturnsManagementService\ProactiveNotification $proactiveNotification
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public function setProactiveNotification(\Pepitelabs\PWS\ReturnsManagementService\ProactiveNotification $proactiveNotification = null)
    {
        if (is_null($proactiveNotification) || (is_array($proactiveNotification) && empty($proactiveNotification))) {
            unset($this->ProactiveNotification);
        } else {
            $this->ProactiveNotification = $proactiveNotification;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ReturnsManagementService\ReturnsManagementShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
