<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageInformation ReturnsManagementService
 * Meta information extracted from the WSDL
 * - documentation: PackageInformation
 * - nillable: true
 * - type: tns:PackageInformation
 * @subpackage Structs
 */
class PackageInformation extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: ServiceID - string
     * - nillable: true
     * @var string
     */
    public $ServiceID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description - string
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The TotalWeight
     * Meta information extracted from the WSDL
     * - documentation: TotalWeight - Weight
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\TotalWeight
     */
    public $TotalWeight;
    /**
     * The TotalPieces
     * Meta information extracted from the WSDL
     * - documentation: TotalPieces - int
     * @var int
     */
    public $TotalPieces;
    /**
     * The PiecesInformation
     * Meta information extracted from the WSDL
     * - documentation: PiecesInformation - Piece[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPiece
     */
    public $PiecesInformation;
    /**
     * The DangerousGoodsDeclarationDocumentIndicator
     * Meta information extracted from the WSDL
     * - documentation: DangerousGoodsDeclarationDocumentIndicator - bool
     * - minOccurs: 0
     * @var bool
     */
    public $DangerousGoodsDeclarationDocumentIndicator;
    /**
     * The OptionsInformation
     * Meta information extracted from the WSDL
     * - documentation: SenderInformation - SenderInformation
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\ReturnsManagementService\OptionsInformation
     */
    public $OptionsInformation;
    /**
     * Constructor method for PackageInformation
     * @uses PackageInformation::setServiceID()
     * @uses PackageInformation::setDescription()
     * @uses PackageInformation::setTotalWeight()
     * @uses PackageInformation::setTotalPieces()
     * @uses PackageInformation::setPiecesInformation()
     * @uses PackageInformation::setDangerousGoodsDeclarationDocumentIndicator()
     * @uses PackageInformation::setOptionsInformation()
     * @param string $serviceID
     * @param string $description
     * @param \Pepitelabs\PWS\ReturnsManagementService\TotalWeight $totalWeight
     * @param int $totalPieces
     * @param \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPiece $piecesInformation
     * @param bool $dangerousGoodsDeclarationDocumentIndicator
     * @param \Pepitelabs\PWS\ReturnsManagementService\OptionsInformation $optionsInformation
     */
    public function __construct($serviceID = null, $description = null, \Pepitelabs\PWS\ReturnsManagementService\TotalWeight $totalWeight = null, $totalPieces = null, \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPiece $piecesInformation = null, $dangerousGoodsDeclarationDocumentIndicator = null, \Pepitelabs\PWS\ReturnsManagementService\OptionsInformation $optionsInformation = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setDescription($description)
            ->setTotalWeight($totalWeight)
            ->setTotalPieces($totalPieces)
            ->setPiecesInformation($piecesInformation)
            ->setDangerousGoodsDeclarationDocumentIndicator($dangerousGoodsDeclarationDocumentIndicator)
            ->setOptionsInformation($optionsInformation);
    }
    /**
     * Get ServiceID value
     * @return string|null
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get TotalWeight value
     * @return \Pepitelabs\PWS\ReturnsManagementService\TotalWeight|null
     */
    public function getTotalWeight()
    {
        return $this->TotalWeight;
    }
    /**
     * Set TotalWeight value
     * @param \Pepitelabs\PWS\ReturnsManagementService\TotalWeight $totalWeight
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public function setTotalWeight(\Pepitelabs\PWS\ReturnsManagementService\TotalWeight $totalWeight = null)
    {
        $this->TotalWeight = $totalWeight;
        return $this;
    }
    /**
     * Get TotalPieces value
     * @return int|null
     */
    public function getTotalPieces()
    {
        return $this->TotalPieces;
    }
    /**
     * Set TotalPieces value
     * @param int $totalPieces
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public function setTotalPieces($totalPieces = null)
    {
        // validation for constraint: int
        if (!is_null($totalPieces) && !(is_int($totalPieces) || ctype_digit($totalPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPieces, true), gettype($totalPieces)), __LINE__);
        }
        $this->TotalPieces = $totalPieces;
        return $this;
    }
    /**
     * Get PiecesInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPiece|null
     */
    public function getPiecesInformation()
    {
        return isset($this->PiecesInformation) ? $this->PiecesInformation : null;
    }
    /**
     * Set PiecesInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ReturnsManagementService\ArrayOfPiece $piecesInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public function setPiecesInformation(\Pepitelabs\PWS\ReturnsManagementService\ArrayOfPiece $piecesInformation = null)
    {
        if (is_null($piecesInformation) || (is_array($piecesInformation) && empty($piecesInformation))) {
            unset($this->PiecesInformation);
        } else {
            $this->PiecesInformation = $piecesInformation;
        }
        return $this;
    }
    /**
     * Get DangerousGoodsDeclarationDocumentIndicator value
     * @return bool|null
     */
    public function getDangerousGoodsDeclarationDocumentIndicator()
    {
        return $this->DangerousGoodsDeclarationDocumentIndicator;
    }
    /**
     * Set DangerousGoodsDeclarationDocumentIndicator value
     * @param bool $dangerousGoodsDeclarationDocumentIndicator
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public function setDangerousGoodsDeclarationDocumentIndicator($dangerousGoodsDeclarationDocumentIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($dangerousGoodsDeclarationDocumentIndicator) && !is_bool($dangerousGoodsDeclarationDocumentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dangerousGoodsDeclarationDocumentIndicator, true), gettype($dangerousGoodsDeclarationDocumentIndicator)), __LINE__);
        }
        $this->DangerousGoodsDeclarationDocumentIndicator = $dangerousGoodsDeclarationDocumentIndicator;
        return $this;
    }
    /**
     * Get OptionsInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\ReturnsManagementService\OptionsInformation|null
     */
    public function getOptionsInformation()
    {
        return isset($this->OptionsInformation) ? $this->OptionsInformation : null;
    }
    /**
     * Set OptionsInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\ReturnsManagementService\OptionsInformation $optionsInformation
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public function setOptionsInformation(\Pepitelabs\PWS\ReturnsManagementService\OptionsInformation $optionsInformation = null)
    {
        if (is_null($optionsInformation) || (is_array($optionsInformation) && empty($optionsInformation))) {
            unset($this->OptionsInformation);
        } else {
            $this->OptionsInformation = $optionsInformation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ReturnsManagementService\PackageInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
