<?php

namespace Pepitelabs\PWS\ReturnsManagementService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardInformation ReturnsManagementService
 * Meta information extracted from the WSDL
 * - documentation: CreditCardInformation
 * - nillable: true
 * - type: tns:CreditCardInformation
 * @subpackage Structs
 */
class CreditCardInformation extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Type - CreditCardType
     * @var string
     */
    public $Type;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Number - string
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name - string
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ExpiryMonth
     * Meta information extracted from the WSDL
     * - documentation: ExpiryMonth - int
     * @var int
     */
    public $ExpiryMonth;
    /**
     * The ExpiryYear
     * Meta information extracted from the WSDL
     * - documentation: ExpiryYear - int
     * @var int
     */
    public $ExpiryYear;
    /**
     * The CVV
     * Meta information extracted from the WSDL
     * - documentation: CVV - string
     * - nillable: true
     * @var string
     */
    public $CVV;
    /**
     * The BillingPostalCode
     * Meta information extracted from the WSDL
     * - documentation: BillingPostalCode - string
     * @var string
     */
    public $BillingPostalCode;
    /**
     * Constructor method for CreditCardInformation
     * @uses CreditCardInformation::setType()
     * @uses CreditCardInformation::setNumber()
     * @uses CreditCardInformation::setName()
     * @uses CreditCardInformation::setExpiryMonth()
     * @uses CreditCardInformation::setExpiryYear()
     * @uses CreditCardInformation::setCVV()
     * @uses CreditCardInformation::setBillingPostalCode()
     * @param string $type
     * @param string $number
     * @param string $name
     * @param int $expiryMonth
     * @param int $expiryYear
     * @param string $cVV
     * @param string $billingPostalCode
     */
    public function __construct($type = null, $number = null, $name = null, $expiryMonth = null, $expiryYear = null, $cVV = null, $billingPostalCode = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setName($name)
            ->setExpiryMonth($expiryMonth)
            ->setExpiryYear($expiryYear)
            ->setCVV($cVV)
            ->setBillingPostalCode($billingPostalCode);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Pepitelabs\PWS\ReturnsManagementService\CreditCardType::valueIsValid()
     * @uses \Pepitelabs\PWS\ReturnsManagementService\CreditCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pepitelabs\PWS\ReturnsManagementService\CreditCardType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Pepitelabs\PWS\ReturnsManagementService\CreditCardType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Pepitelabs\PWS\ReturnsManagementService\CreditCardType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ExpiryMonth value
     * @return int|null
     */
    public function getExpiryMonth()
    {
        return $this->ExpiryMonth;
    }
    /**
     * Set ExpiryMonth value
     * @param int $expiryMonth
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public function setExpiryMonth($expiryMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expiryMonth) && !(is_int($expiryMonth) || ctype_digit($expiryMonth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiryMonth, true), gettype($expiryMonth)), __LINE__);
        }
        $this->ExpiryMonth = $expiryMonth;
        return $this;
    }
    /**
     * Get ExpiryYear value
     * @return int|null
     */
    public function getExpiryYear()
    {
        return $this->ExpiryYear;
    }
    /**
     * Set ExpiryYear value
     * @param int $expiryYear
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public function setExpiryYear($expiryYear = null)
    {
        // validation for constraint: int
        if (!is_null($expiryYear) && !(is_int($expiryYear) || ctype_digit($expiryYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expiryYear, true), gettype($expiryYear)), __LINE__);
        }
        $this->ExpiryYear = $expiryYear;
        return $this;
    }
    /**
     * Get CVV value
     * @return string|null
     */
    public function getCVV()
    {
        return $this->CVV;
    }
    /**
     * Set CVV value
     * @param string $cVV
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public function setCVV($cVV = null)
    {
        // validation for constraint: string
        if (!is_null($cVV) && !is_string($cVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cVV, true), gettype($cVV)), __LINE__);
        }
        $this->CVV = $cVV;
        return $this;
    }
    /**
     * Get BillingPostalCode value
     * @return string|null
     */
    public function getBillingPostalCode()
    {
        return $this->BillingPostalCode;
    }
    /**
     * Set BillingPostalCode value
     * @param string $billingPostalCode
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public function setBillingPostalCode($billingPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingPostalCode) && !is_string($billingPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingPostalCode, true), gettype($billingPostalCode)), __LINE__);
        }
        $this->BillingPostalCode = $billingPostalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\ReturnsManagementService\CreditCardInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
