<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationalMessage TrackingService
 * Meta information extracted from the WSDL
 * - documentation: InformationalMessage
 * - nillable: true
 * - type: tns:InformationalMessage
 * @subpackage Structs
 */
class InformationalMessage extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Code - string
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - documentation: Message - string
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * Constructor method for InformationalMessage
     * @uses InformationalMessage::setCode()
     * @uses InformationalMessage::setMessage()
     * @param string $code
     * @param string $message
     */
    public function __construct($code = null, $message = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Pepitelabs\PWS\TrackingService\InformationalMessage
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Pepitelabs\PWS\TrackingService\InformationalMessage
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\TrackingService\InformationalMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
