<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UndeliverableScanDetails TrackingService
 * Meta information extracted from the WSDL
 * - documentation: UndeliverableScanDetails
 * - nillable: true
 * - type: tns:UndeliverableScanDetails
 * @subpackage Structs
 */
class UndeliverableScanDetails extends AbstractStructBase
{
    /**
     * The AttemptedDeliveryAddress
     * Meta information extracted from the WSDL
     * - documentation: AttemptedDeliveryAddress - string
     * - nillable: true
     * @var string
     */
    public $AttemptedDeliveryAddress;
    /**
     * The DeliveryCompanyName
     * Meta information extracted from the WSDL
     * - documentation: DeliveryCompanyName - string
     * - nillable: true
     * @var string
     */
    public $DeliveryCompanyName;
    /**
     * Constructor method for UndeliverableScanDetails
     * @uses UndeliverableScanDetails::setAttemptedDeliveryAddress()
     * @uses UndeliverableScanDetails::setDeliveryCompanyName()
     * @param string $attemptedDeliveryAddress
     * @param string $deliveryCompanyName
     */
    public function __construct($attemptedDeliveryAddress = null, $deliveryCompanyName = null)
    {
        $this
            ->setAttemptedDeliveryAddress($attemptedDeliveryAddress)
            ->setDeliveryCompanyName($deliveryCompanyName);
    }
    /**
     * Get AttemptedDeliveryAddress value
     * @return string|null
     */
    public function getAttemptedDeliveryAddress()
    {
        return $this->AttemptedDeliveryAddress;
    }
    /**
     * Set AttemptedDeliveryAddress value
     * @param string $attemptedDeliveryAddress
     * @return \Pepitelabs\PWS\TrackingService\UndeliverableScanDetails
     */
    public function setAttemptedDeliveryAddress($attemptedDeliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($attemptedDeliveryAddress) && !is_string($attemptedDeliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attemptedDeliveryAddress, true), gettype($attemptedDeliveryAddress)), __LINE__);
        }
        $this->AttemptedDeliveryAddress = $attemptedDeliveryAddress;
        return $this;
    }
    /**
     * Get DeliveryCompanyName value
     * @return string|null
     */
    public function getDeliveryCompanyName()
    {
        return $this->DeliveryCompanyName;
    }
    /**
     * Set DeliveryCompanyName value
     * @param string $deliveryCompanyName
     * @return \Pepitelabs\PWS\TrackingService\UndeliverableScanDetails
     */
    public function setDeliveryCompanyName($deliveryCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryCompanyName) && !is_string($deliveryCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryCompanyName, true), gettype($deliveryCompanyName)), __LINE__);
        }
        $this->DeliveryCompanyName = $deliveryCompanyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\TrackingService\UndeliverableScanDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
