<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingInformation TrackingService
 * Meta information extracted from the WSDL
 * - documentation: TrackingInformation
 * - nillable: true
 * - type: tns:TrackingInformation
 * @subpackage Structs
 */
class TrackingInformation extends AbstractStructBase
{
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - documentation: PIN - PIN
     * - nillable: true
     * @var \Pepitelabs\PWS\TrackingService\PIN
     */
    public $PIN;
    /**
     * The Scans
     * Meta information extracted from the WSDL
     * - documentation: Scans - Scan[]
     * - minOccurs: 0
     * - nillable: true
     * @var \Pepitelabs\PWS\TrackingService\ArrayOfScan
     */
    public $Scans;
    /**
     * The ResponseInformation
     * Meta information extracted from the WSDL
     * - documentation: ResponseInformation - ResponseInformation
     * - nillable: true
     * @var \Pepitelabs\PWS\TrackingService\ResponseInformation
     */
    public $ResponseInformation;
    /**
     * Constructor method for TrackingInformation
     * @uses TrackingInformation::setPIN()
     * @uses TrackingInformation::setScans()
     * @uses TrackingInformation::setResponseInformation()
     * @param \Pepitelabs\PWS\TrackingService\PIN $pIN
     * @param \Pepitelabs\PWS\TrackingService\ArrayOfScan $scans
     * @param \Pepitelabs\PWS\TrackingService\ResponseInformation $responseInformation
     */
    public function __construct(\Pepitelabs\PWS\TrackingService\PIN $pIN = null, \Pepitelabs\PWS\TrackingService\ArrayOfScan $scans = null, \Pepitelabs\PWS\TrackingService\ResponseInformation $responseInformation = null)
    {
        $this
            ->setPIN($pIN)
            ->setScans($scans)
            ->setResponseInformation($responseInformation);
    }
    /**
     * Get PIN value
     * @return \Pepitelabs\PWS\TrackingService\PIN|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param \Pepitelabs\PWS\TrackingService\PIN $pIN
     * @return \Pepitelabs\PWS\TrackingService\TrackingInformation
     */
    public function setPIN(\Pepitelabs\PWS\TrackingService\PIN $pIN = null)
    {
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get Scans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pepitelabs\PWS\TrackingService\ArrayOfScan|null
     */
    public function getScans()
    {
        return isset($this->Scans) ? $this->Scans : null;
    }
    /**
     * Set Scans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pepitelabs\PWS\TrackingService\ArrayOfScan $scans
     * @return \Pepitelabs\PWS\TrackingService\TrackingInformation
     */
    public function setScans(\Pepitelabs\PWS\TrackingService\ArrayOfScan $scans = null)
    {
        if (is_null($scans) || (is_array($scans) && empty($scans))) {
            unset($this->Scans);
        } else {
            $this->Scans = $scans;
        }
        return $this;
    }
    /**
     * Get ResponseInformation value
     * @return \Pepitelabs\PWS\TrackingService\ResponseInformation|null
     */
    public function getResponseInformation()
    {
        return $this->ResponseInformation;
    }
    /**
     * Set ResponseInformation value
     * @param \Pepitelabs\PWS\TrackingService\ResponseInformation $responseInformation
     * @return \Pepitelabs\PWS\TrackingService\TrackingInformation
     */
    public function setResponseInformation(\Pepitelabs\PWS\TrackingService\ResponseInformation $responseInformation = null)
    {
        $this->ResponseInformation = $responseInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\TrackingService\TrackingInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
