<?php

namespace Pepitelabs\PWS\TrackingService;

/**
 * This class stands for SignatureImageFormat TrackingService
 * Meta information extracted from the WSDL
 * - documentation: SignatureImageFormat - enum
 * - nillable: true
 * - type: tns:SignatureImageFormat
 * @subpackage Enumerations
 */
class SignatureImageFormat
{
    /**
     * Constant for value 'GIF'
     * Meta information extracted from the WSDL
     * - documentation: GIF
     * @return string 'GIF'
     */
    const VALUE_GIF = 'GIF';
    /**
     * Constant for value 'Bitmap'
     * Meta information extracted from the WSDL
     * - documentation: Bitmap
     * @return string 'Bitmap'
     */
    const VALUE_BITMAP = 'Bitmap';
    /**
     * Constant for value 'OriginalUncompressed'
     * Meta information extracted from the WSDL
     * - documentation: OriginalUncompressed
     * @return string 'OriginalUncompressed'
     */
    const VALUE_ORIGINAL_UNCOMPRESSED = 'OriginalUncompressed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GIF
     * @uses self::VALUE_BITMAP
     * @uses self::VALUE_ORIGINAL_UNCOMPRESSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GIF,
            self::VALUE_BITMAP,
            self::VALUE_ORIGINAL_UNCOMPRESSED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
