<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Scan TrackingService
 * Meta information extracted from the WSDL
 * - documentation: Scan
 * - nillable: true
 * - type: tns:Scan
 * @subpackage Structs
 */
class Scan extends AbstractStructBase
{
    /**
     * The ScanType
     * Meta information extracted from the WSDL
     * - documentation: ScanType - ScanType
     * - nillable: true
     * @var string
     */
    public $ScanType;
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - documentation: PIN - PIN
     * - nillable: true
     * @var \Pepitelabs\PWS\TrackingService\PIN
     */
    public $PIN;
    /**
     * The Depot
     * Meta information extracted from the WSDL
     * - documentation: Depot - Depot
     * - nillable: true
     * @var \Pepitelabs\PWS\TrackingService\Depot
     */
    public $Depot;
    /**
     * The ScanDate
     * Meta information extracted from the WSDL
     * - documentation: ScanDate - string
     * - nillable: true
     * @var string
     */
    public $ScanDate;
    /**
     * The ScanTime
     * Meta information extracted from the WSDL
     * - documentation: ScanTime - string
     * - nillable: true
     * @var string
     */
    public $ScanTime;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description - string
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment - string
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The SummaryScanIndicator
     * Meta information extracted from the WSDL
     * - documentation: SummaryScanIndicator - bool
     * @var bool
     */
    public $SummaryScanIndicator;
    /**
     * Constructor method for Scan
     * @uses Scan::setScanType()
     * @uses Scan::setPIN()
     * @uses Scan::setDepot()
     * @uses Scan::setScanDate()
     * @uses Scan::setScanTime()
     * @uses Scan::setDescription()
     * @uses Scan::setComment()
     * @uses Scan::setSummaryScanIndicator()
     * @param string $scanType
     * @param \Pepitelabs\PWS\TrackingService\PIN $pIN
     * @param \Pepitelabs\PWS\TrackingService\Depot $depot
     * @param string $scanDate
     * @param string $scanTime
     * @param string $description
     * @param string $comment
     * @param bool $summaryScanIndicator
     */
    public function __construct($scanType = null, \Pepitelabs\PWS\TrackingService\PIN $pIN = null, \Pepitelabs\PWS\TrackingService\Depot $depot = null, $scanDate = null, $scanTime = null, $description = null, $comment = null, $summaryScanIndicator = null)
    {
        $this
            ->setScanType($scanType)
            ->setPIN($pIN)
            ->setDepot($depot)
            ->setScanDate($scanDate)
            ->setScanTime($scanTime)
            ->setDescription($description)
            ->setComment($comment)
            ->setSummaryScanIndicator($summaryScanIndicator);
    }
    /**
     * Get ScanType value
     * @return string|null
     */
    public function getScanType()
    {
        return $this->ScanType;
    }
    /**
     * Set ScanType value
     * @param string $scanType
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setScanType($scanType = null)
    {
        // validation for constraint: string
        if (!is_null($scanType) && !is_string($scanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanType, true), gettype($scanType)), __LINE__);
        }
        $this->ScanType = $scanType;
        return $this;
    }
    /**
     * Get PIN value
     * @return \Pepitelabs\PWS\TrackingService\PIN|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param \Pepitelabs\PWS\TrackingService\PIN $pIN
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setPIN(\Pepitelabs\PWS\TrackingService\PIN $pIN = null)
    {
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get Depot value
     * @return \Pepitelabs\PWS\TrackingService\Depot|null
     */
    public function getDepot()
    {
        return $this->Depot;
    }
    /**
     * Set Depot value
     * @param \Pepitelabs\PWS\TrackingService\Depot $depot
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setDepot(\Pepitelabs\PWS\TrackingService\Depot $depot = null)
    {
        $this->Depot = $depot;
        return $this;
    }
    /**
     * Get ScanDate value
     * @return string|null
     */
    public function getScanDate()
    {
        return $this->ScanDate;
    }
    /**
     * Set ScanDate value
     * @param string $scanDate
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanDate, true), gettype($scanDate)), __LINE__);
        }
        $this->ScanDate = $scanDate;
        return $this;
    }
    /**
     * Get ScanTime value
     * @return string|null
     */
    public function getScanTime()
    {
        return $this->ScanTime;
    }
    /**
     * Set ScanTime value
     * @param string $scanTime
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setScanTime($scanTime = null)
    {
        // validation for constraint: string
        if (!is_null($scanTime) && !is_string($scanTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanTime, true), gettype($scanTime)), __LINE__);
        }
        $this->ScanTime = $scanTime;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get SummaryScanIndicator value
     * @return bool|null
     */
    public function getSummaryScanIndicator()
    {
        return $this->SummaryScanIndicator;
    }
    /**
     * Set SummaryScanIndicator value
     * @param bool $summaryScanIndicator
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public function setSummaryScanIndicator($summaryScanIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($summaryScanIndicator) && !is_bool($summaryScanIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($summaryScanIndicator, true), gettype($summaryScanIndicator)), __LINE__);
        }
        $this->SummaryScanIndicator = $summaryScanIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\TrackingService\Scan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
