<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternationalOutboundScanDetails TrackingService
 * Meta information extracted from the WSDL
 * - documentation: InternationalOutboundScanDetails
 * - nillable: true
 * - type: tns:InternationalOutboundScanDetails
 * @subpackage Structs
 */
class InternationalOutboundScanDetails extends AbstractStructBase
{
    /**
     * The DestinationPostalCode
     * Meta information extracted from the WSDL
     * - documentation: DestinationPostalCode - string
     * - nillable: true
     * @var string
     */
    public $DestinationPostalCode;
    /**
     * The AirportCode
     * Meta information extracted from the WSDL
     * - documentation: AirportCode - string
     * - nillable: true
     * @var string
     */
    public $AirportCode;
    /**
     * Constructor method for InternationalOutboundScanDetails
     * @uses InternationalOutboundScanDetails::setDestinationPostalCode()
     * @uses InternationalOutboundScanDetails::setAirportCode()
     * @param string $destinationPostalCode
     * @param string $airportCode
     */
    public function __construct($destinationPostalCode = null, $airportCode = null)
    {
        $this
            ->setDestinationPostalCode($destinationPostalCode)
            ->setAirportCode($airportCode);
    }
    /**
     * Get DestinationPostalCode value
     * @return string|null
     */
    public function getDestinationPostalCode()
    {
        return $this->DestinationPostalCode;
    }
    /**
     * Set DestinationPostalCode value
     * @param string $destinationPostalCode
     * @return \Pepitelabs\PWS\TrackingService\InternationalOutboundScanDetails
     */
    public function setDestinationPostalCode($destinationPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPostalCode) && !is_string($destinationPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPostalCode, true), gettype($destinationPostalCode)), __LINE__);
        }
        $this->DestinationPostalCode = $destinationPostalCode;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \Pepitelabs\PWS\TrackingService\InternationalOutboundScanDetails
     */
    public function setAirportCode($airportCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportCode) && !is_string($airportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportCode, true), gettype($airportCode)), __LINE__);
        }
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pepitelabs\PWS\TrackingService\InternationalOutboundScanDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
