<?php

namespace Pepitelabs\PWS\TrackingService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get TrackingService
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Pepitelabs\PWS\TrackingService\RequestContext $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\Pepitelabs\PWS\TrackingService\RequestContext $requestContext, $nameSpace = 'http://purolator.com/pws/service/v1', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetDeliveryDetails
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://purolator.com/pws/service/v1
     * - SOAPHeaderTypes: \Pepitelabs\PWS\TrackingService\RequestContext
     * - SOAPHeaders: required
     * - documentation: GetDeliveryDetails @param request GetDeliveryDetailsRequest @return GetDeliveryDetailsResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Pepitelabs\PWS\TrackingService\GetDeliveryDetailsRequestContainer $getDeliveryDetailsRequest
     * @return \Pepitelabs\PWS\TrackingService\GetDeliveryDetailsResponseContainer|bool
     */
    public function GetDeliveryDetails(\Pepitelabs\PWS\TrackingService\GetDeliveryDetailsRequestContainer $getDeliveryDetailsRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryDetails($getDeliveryDetailsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Pepitelabs\PWS\TrackingService\GetDeliveryDetailsResponseContainer
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
